/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.variables.AbstractDistributedValue;
import io.atomix.variables.internal.ValueCommands;

public final class LongCommands {
    private LongCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(ValueCommands.CompareAndSet.class, -110);
            registry.register(ValueCommands.Get.class, -111);
            registry.register(ValueCommands.GetAndSet.class, -112);
            registry.register(ValueCommands.Set.class, -113);
            registry.register(IncrementAndGet.class, -114);
            registry.register(DecrementAndGet.class, -115);
            registry.register(GetAndIncrement.class, -116);
            registry.register(GetAndDecrement.class, -117);
            registry.register(AddAndGet.class, -118);
            registry.register(GetAndAdd.class, -119);
            registry.register(AbstractDistributedValue.ChangeEvent.class, -120);
            registry.register(ValueCommands.Register.class, -121);
            registry.register(ValueCommands.Unregister.class, -122);
        }
    }

    public static class AddAndGet
    extends DeltaCommand {
        public AddAndGet() {
        }

        public AddAndGet(long delta) {
            super(delta);
        }
    }

    public static class GetAndAdd
    extends DeltaCommand {
        public GetAndAdd() {
        }

        public GetAndAdd(long delta) {
            super(delta);
        }
    }

    public static abstract class DeltaCommand
    extends LongCommand<Long> {
        private long delta;

        public DeltaCommand() {
        }

        public DeltaCommand(long delta) {
            this.delta = delta;
        }

        public long delta() {
            return this.delta;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeLong(this.delta);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.delta = buffer.readLong();
        }
    }

    public static class GetAndDecrement
    extends LongCommand<Long> {
    }

    public static class GetAndIncrement
    extends LongCommand<Long> {
    }

    public static class DecrementAndGet
    extends LongCommand<Long> {
    }

    public static class IncrementAndGet
    extends LongCommand<Long> {
    }

    public static abstract class LongCommand<V>
    implements Command<V>,
    CatalystSerializable {
        protected LongCommand() {
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SNAPSHOT;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

