/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.variables.internal.ValueCommands;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class AbstractDistributedValue<T extends AbstractDistributedValue<T, U>, U>
extends AbstractResource<T> {
    protected AbstractDistributedValue(CopycatClient client, Properties options) {
        super(client, options);
    }

    public synchronized CompletableFuture<Listener<ChangeEvent<U>>> onChange(Consumer<ChangeEvent<U>> callback) {
        return this.onEvent(Events.CHANGE, callback);
    }

    public CompletableFuture<U> get() {
        return this.client.submit(new ValueCommands.Get());
    }

    public CompletableFuture<U> get(ReadConsistency consistency) {
        return this.client.submit(new ValueCommands.Get(consistency.level()));
    }

    public CompletableFuture<Void> set(U value) {
        return this.client.submit(new ValueCommands.Set<U>(value));
    }

    public CompletableFuture<Void> set(U value, Duration ttl) {
        return this.client.submit(new ValueCommands.Set<U>(value, ttl.toMillis()));
    }

    public CompletableFuture<U> getAndSet(U value) {
        return this.client.submit(new ValueCommands.GetAndSet<U>(value));
    }

    public CompletableFuture<U> getAndSet(U value, Duration ttl) {
        return this.client.submit(new ValueCommands.GetAndSet<U>(value, ttl.toMillis()));
    }

    public CompletableFuture<Boolean> compareAndSet(U expect, U update) {
        return this.client.submit(new ValueCommands.CompareAndSet<U>(expect, update));
    }

    public CompletableFuture<Boolean> compareAndSet(U expect, U update, Duration ttl) {
        return this.client.submit(new ValueCommands.CompareAndSet<U>(expect, update, ttl.toMillis()));
    }

    public static class ChangeEvent<T>
    implements Resource.Event,
    CatalystSerializable {
        private T oldValue;
        private T newValue;

        public ChangeEvent() {
        }

        public ChangeEvent(T oldValue, T newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public Resource.EventType type() {
            return Events.CHANGE;
        }

        public T oldValue() {
            return this.oldValue;
        }

        public T newValue() {
            return this.newValue;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.oldValue, buffer);
            serializer.writeObject(this.newValue, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.oldValue = serializer.readObject(buffer);
            this.newValue = serializer.readObject(buffer);
        }

        public String toString() {
            return String.format("%s[oldValue=%s, newValue=%s]", this.getClass().getSimpleName(), this.oldValue, this.newValue);
        }
    }

    public static enum Events implements Resource.EventType
    {
        CHANGE;


        @Override
        public int id() {
            return this.ordinal();
        }
    }
}

