/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Operation;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineContext;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceCommit;
import io.atomix.resource.internal.ResourceQuery;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;

public final class ResourceStateMachineExecutor
implements StateMachineExecutor {
    private final StateMachineExecutor parent;
    private final Map<Class, Function> callbacks = new HashMap<Class, Function>();

    ResourceStateMachineExecutor(StateMachineExecutor parent) {
        this.parent = Assert.notNull(parent, "parent");
        parent.register(ResourceCommand.class, this::executeCommand);
        parent.register(ResourceQuery.class, this::executeQuery);
    }

    @Override
    public StateMachineContext context() {
        return this.parent.context();
    }

    @Override
    public Logger logger() {
        return this.parent.logger();
    }

    @Override
    public Serializer serializer() {
        return this.parent.serializer();
    }

    @Override
    public Executor executor() {
        return this.parent.executor();
    }

    private Object executeCommand(Commit<ResourceCommand> commit) {
        Function function = this.callbacks.get(commit.operation().operation().getClass());
        if (function != null) {
            return function.apply(new ResourceCommit(commit));
        }
        throw new IllegalStateException("unknown operation type: " + commit.operation().operation().getClass());
    }

    private Object executeQuery(Commit<ResourceQuery> commit) {
        Function function = this.callbacks.get(commit.operation().operation().getClass());
        if (function != null) {
            return function.apply(new ResourceCommit(commit));
        }
        throw new IllegalStateException("unknown operation type: " + commit.operation().operation().getClass());
    }

    @Override
    public <T extends Operation<Void>> StateMachineExecutor register(Class<T> type, Consumer<Commit<T>> callback) {
        return this.register(type, (Commit<T> c) -> {
            callback.accept((Commit)c);
            return null;
        });
    }

    @Override
    public <T extends Operation<U>, U> StateMachineExecutor register(Class<T> type, Function<Commit<T>, U> callback) {
        this.callbacks.put(type, Assert.notNull(callback, "callback"));
        return this;
    }

    @Override
    public Scheduled schedule(Duration delay, Runnable callback) {
        return this.parent.schedule(delay, callback);
    }

    @Override
    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
        return this.parent.schedule(initialDelay, interval, callback);
    }
}

