/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceStateMachineExecutor;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceEvent;
import io.atomix.resource.internal.ResourceQuery;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ResourceStateMachine
extends StateMachine
implements SessionListener {
    protected final Properties config;
    private final Map<Integer, Set<ServerSession>> eventListeners = new HashMap<Integer, Set<ServerSession>>();

    protected ResourceStateMachine(Properties config) {
        this.config = Assert.notNull(config, "config");
    }

    @Override
    public final void init(StateMachineExecutor executor) {
        executor.serializer().register(ResourceCommand.class, -50);
        executor.serializer().register(ResourceQuery.class, -51);
        executor.serializer().register(ResourceQuery.Config.class, -52);
        executor.serializer().register(ResourceCommand.Delete.class, -53);
        executor.serializer().register(ResourceEvent.class, -49);
        executor.context().sessions().addListener(this);
        ResourceStateMachineExecutor wrappedExecutor = new ResourceStateMachineExecutor(executor);
        wrappedExecutor.register(ResourceQuery.Config.class, this::config);
        wrappedExecutor.register(ResourceCommand.Register.class, this::register);
        wrappedExecutor.register(ResourceCommand.Unregister.class, this::unregister);
        wrappedExecutor.register(ResourceCommand.Delete.class, this::delete);
        super.init(wrappedExecutor);
    }

    @Override
    public void register(ServerSession session) {
    }

    @Override
    public void unregister(ServerSession session) {
    }

    @Override
    public void expire(ServerSession session) {
    }

    @Override
    public void close(ServerSession session) {
    }

    protected void notify(Resource.Event event) {
        Set<ServerSession> sessions = this.eventListeners.get(event.type().id());
        if (sessions != null) {
            for (ServerSession session : sessions) {
                session.publish("event", new ResourceEvent(event.type().id(), event));
            }
        }
    }

    private Properties config(Commit<ResourceQuery.Config> commit) {
        try {
            Properties properties = this.config;
            return properties;
        }
        finally {
            commit.close();
        }
    }

    private void register(Commit<ResourceCommand.Register> commit) {
        Set sessions = this.eventListeners.computeIfAbsent(commit.command().event(), k -> new HashSet());
        sessions.add(commit.session());
    }

    private void unregister(Commit<ResourceCommand.Unregister> commit) {
        Set sessions = this.eventListeners.computeIfAbsent(commit.command().event(), k -> new HashSet());
        sessions.remove(commit.session());
        if (sessions.isEmpty()) {
            this.eventListeners.remove(commit.command().event());
        }
    }

    private void delete(Commit<ResourceCommand.Delete> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
    }
}

