/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.messaging.internal.AbstractMessageConsumer;
import io.atomix.group.messaging.internal.GroupMessage;
import io.atomix.group.messaging.internal.MessageConsumerRegistry;
import java.util.concurrent.CompletableFuture;

public class MessageConsumerService {
    private final MessageConsumerRegistry registry = new MessageConsumerRegistry();
    private final CopycatClient client;

    public MessageConsumerService(CopycatClient client) {
        this.client = Assert.notNull(client, "submitter");
    }

    MessageConsumerRegistry registry() {
        return this.registry;
    }

    public void onMessage(GroupMessage message) {
        AbstractMessageConsumer consumer = this.registry.get(message.queue());
        message.setConsumerService(this);
        if (consumer != null) {
            consumer.onMessage(message);
        } else {
            message.fail();
        }
    }

    public CompletableFuture<Void> reply(GroupCommands.Reply reply) {
        return this.client.submit(reply);
    }
}

