/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.messaging.Message;
import io.atomix.group.messaging.internal.MessageConsumerService;
import java.util.concurrent.CompletableFuture;

public class GroupMessage<T>
implements Message<T>,
CatalystSerializable {
    private long id;
    private String member;
    private String queue;
    private T value;
    private transient MessageConsumerService consumerService;

    public GroupMessage() {
    }

    public GroupMessage(long id, String member, String queue, T value) {
        this.id = id;
        this.member = member;
        this.queue = queue;
        this.value = value;
    }

    GroupMessage<T> setConsumerService(MessageConsumerService consumerService) {
        this.consumerService = consumerService;
        return this;
    }

    @Override
    public long id() {
        return this.id;
    }

    public String member() {
        return this.member;
    }

    public String queue() {
        return this.queue;
    }

    @Override
    public T message() {
        return this.value;
    }

    @Override
    public CompletableFuture<Void> reply(Object message) {
        return this.consumerService.reply(new GroupCommands.Reply(this.member, this.queue, this.id, true, message));
    }

    @Override
    public CompletableFuture<Void> ack() {
        return this.consumerService.reply(new GroupCommands.Reply(this.member, this.queue, this.id, true, null));
    }

    @Override
    public CompletableFuture<Void> fail() {
        return this.consumerService.reply(new GroupCommands.Reply(this.member, this.queue, this.id, false, null));
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.id);
        buffer.writeString(this.member);
        buffer.writeString(this.queue);
        serializer.writeObject(this.value, buffer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.id = buffer.readLong();
        this.member = buffer.readString();
        this.queue = buffer.readString();
        this.value = serializer.readObject(buffer);
    }

    public String toString() {
        return String.format("%s[member=%s]", this.getClass().getSimpleName(), this.member);
    }
}

