/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.copycat.server.session.ServerSession;
import io.atomix.group.internal.MemberState;

final class SessionState {
    private final ServerSession session;

    SessionState(ServerSession session) {
        this.session = session;
    }

    public long id() {
        return this.session.id();
    }

    public void join(MemberState member) {
        if (this.session.state().active()) {
            this.session.publish("join", member.info());
        }
    }

    public void alive(MemberState member) {
        if (this.session.state().active()) {
            this.session.publish("alive", member.id());
        }
    }

    public void dead(MemberState member) {
        if (this.session.state().active()) {
            this.session.publish("dead", member.id());
        }
    }

    public void leave(MemberState member) {
        if (this.session.state().active()) {
            this.session.publish("leave", member.id());
        }
    }

    public void term(long term) {
        if (this.session.state().active()) {
            this.session.publish("term", term);
        }
    }

    public void elect(MemberState member) {
        if (this.session.state().active()) {
            this.session.publish("elect", member.id());
        }
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SessionState && ((SessionState)object).session.equals(this.session);
    }
}

