/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.group.DistributedGroup;
import io.atomix.group.GroupMember;
import io.atomix.group.LocalMember;
import io.atomix.group.election.Election;
import io.atomix.group.election.internal.GroupElection;
import io.atomix.group.internal.AbstractGroupMember;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.GroupMemberInfo;
import io.atomix.group.internal.LocalGroupMember;
import io.atomix.group.internal.RemoteGroupMember;
import io.atomix.group.messaging.MessageClient;
import io.atomix.group.messaging.internal.GroupMessage;
import io.atomix.group.messaging.internal.GroupMessageClient;
import io.atomix.group.messaging.internal.MessageConsumerService;
import io.atomix.group.messaging.internal.MessageProducerService;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class MembershipGroup
extends AbstractResource<DistributedGroup>
implements DistributedGroup {
    private final Listeners<GroupMember> joinListeners = new Listeners();
    private final Listeners<GroupMember> leaveListeners = new Listeners();
    private final GroupElection election = new GroupElection(this);
    private final GroupMessageClient messages;
    private final DistributedGroup.Options options;
    private final Map<String, AbstractGroupMember> members = new ConcurrentHashMap<String, AbstractGroupMember>();
    private final MessageProducerService producerService;
    private final MessageConsumerService consumerService;
    private final Map<String, GroupCommands.Join> localJoins = new ConcurrentHashMap<String, GroupCommands.Join>();

    public MembershipGroup(CopycatClient client, Properties options) {
        super(client, new ResourceType(DistributedGroup.class), options);
        this.producerService = new MessageProducerService(this.client);
        this.consumerService = new MessageConsumerService(this.client);
        this.messages = new GroupMessageClient(this.producerService);
        this.options = new DistributedGroup.Options(options);
    }

    @Override
    public DistributedGroup.Config config() {
        return new DistributedGroup.Config(this.config);
    }

    @Override
    public DistributedGroup.Options options() {
        return this.options;
    }

    @Override
    public Election election() {
        return this.election;
    }

    @Override
    public MessageClient messaging() {
        return this.messages;
    }

    @Override
    public GroupMember member(String memberId) {
        return this.members.get(memberId);
    }

    @Override
    public Collection<GroupMember> members() {
        return this.members.values();
    }

    @Override
    public CompletableFuture<LocalMember> join() {
        return this.join(UUID.randomUUID().toString(), false, null);
    }

    @Override
    public CompletableFuture<LocalMember> join(String memberId) {
        return this.join(memberId, true, null);
    }

    @Override
    public CompletableFuture<LocalMember> join(Object metadata) {
        return this.join(UUID.randomUUID().toString(), false, metadata);
    }

    @Override
    public CompletableFuture<LocalMember> join(String memberId, Object metadata) {
        return this.join(memberId == null ? UUID.randomUUID().toString() : memberId, memberId != null, metadata);
    }

    private CompletableFuture<LocalMember> join(String memberId, boolean persistent, Object metadata) {
        GroupCommands.Join cmd = new GroupCommands.Join(memberId, persistent, metadata);
        return this.client.submit(cmd).thenApply(info -> {
            AbstractGroupMember member = this.members.get(info.memberId());
            if (member == null || !(member instanceof LocalGroupMember)) {
                member = new LocalGroupMember((GroupMemberInfo)info, this, this.producerService, this.consumerService);
                this.localJoins.put(memberId, cmd);
                this.members.put(info.memberId(), member);
            }
            return (LocalGroupMember)member;
        });
    }

    @Override
    public Listener<GroupMember> onJoin(Consumer<GroupMember> listener) {
        return this.joinListeners.add(listener);
    }

    @Override
    public CompletableFuture<Void> remove(String memberId) {
        return this.client.submit(new GroupCommands.Leave(memberId)).thenRun(() -> {
            this.localJoins.remove(memberId);
            GroupMember member = this.members.remove(memberId);
            if (member != null) {
                this.leaveListeners.accept(member);
            }
        });
    }

    @Override
    public Listener<GroupMember> onLeave(Consumer<GroupMember> listener) {
        return this.leaveListeners.add(listener);
    }

    @Override
    public CompletableFuture<DistributedGroup> open() {
        return ((CompletableFuture)((CompletableFuture)super.open().thenApply(result -> {
            this.client.onEvent("join", this::onJoinEvent);
            this.client.onEvent("leave", this::onLeaveEvent);
            this.client.onEvent("alive", this::onAliveEvent);
            this.client.onEvent("dead", this::onDeadEvent);
            this.client.onEvent("message", this::onMessageEvent);
            this.client.onEvent("ack", this::onAckEvent);
            this.client.onEvent("term", this::onTermEvent);
            this.client.onEvent("elect", this::onElectEvent);
            return result;
        })).thenCompose(v -> this.sync())).thenApply(v -> this);
    }

    @Override
    protected CompletableFuture<Void> recover(Integer attempt) {
        Boolean recover = Boolean.parseBoolean(this.options.getProperty("recover", "true"));
        if (!recover.booleanValue()) {
            return Futures.completedFuture(null);
        }
        HashMap<String, GroupCommands.Join> joins = new HashMap<String, GroupCommands.Join>(this.localJoins);
        return ((CompletableFuture)((CompletableFuture)this.sync().thenCompose(v -> {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(joins.size());
            for (GroupCommands.Join join : joins.values()) {
                if (join.persist()) continue;
                futures.add(this.remove(join.member()));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        })).thenCompose(v -> this.sync())).thenCompose(v -> {
            ArrayList<CompletableFuture<LocalMember>> futures = new ArrayList<CompletableFuture<LocalMember>>(joins.size());
            for (GroupCommands.Join join : joins.values()) {
                if (join.persist()) {
                    futures.add(this.join(join.member(), join.persist(), join.metadata()));
                    continue;
                }
                futures.add(this.join(join.metadata()));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        });
    }

    private CompletableFuture<Void> sync() {
        return this.client.submit(new GroupCommands.Listen()).thenAccept(status -> {
            GroupMember leader;
            for (GroupMemberInfo info : status.members()) {
                AbstractGroupMember member = this.members.get(info.memberId());
                if (member != null) continue;
                member = new RemoteGroupMember(info, this, this.producerService);
                this.members.put(member.id(), member);
            }
            this.election.setTerm(status.term());
            if (status.leader() != null && (leader = (GroupMember)this.members.get(status.leader())) != null) {
                this.election.setLeader(leader);
            }
        });
    }

    private void onJoinEvent(GroupMemberInfo info) {
        AbstractGroupMember member = this.members.get(info.memberId());
        if (member == null) {
            member = new RemoteGroupMember(info, this, this.producerService);
            this.members.put(info.memberId(), member);
            this.joinListeners.accept(member);
        } else {
            member.onStatusChange(GroupMember.Status.ALIVE);
            if (member instanceof LocalGroupMember) {
                this.joinListeners.accept(member);
            }
        }
    }

    private void onLeaveEvent(String memberId) {
        GroupMember member = this.members.remove(memberId);
        if (member != null) {
            this.leaveListeners.accept(member);
        }
    }

    private void onAliveEvent(String memberId) {
        AbstractGroupMember member = this.members.get(memberId);
        if (member != null) {
            member.onStatusChange(GroupMember.Status.ALIVE);
        }
    }

    private void onDeadEvent(String memberId) {
        AbstractGroupMember member = this.members.get(memberId);
        if (member != null) {
            member.onStatusChange(GroupMember.Status.DEAD);
        }
    }

    private void onMessageEvent(GroupMessage message) {
        this.consumerService.onMessage(message);
    }

    private void onAckEvent(GroupCommands.Ack ack) {
        this.producerService.onAck(ack);
    }

    private void onTermEvent(long term) {
        this.election.onTerm(term);
    }

    private void onElectEvent(String memberId) {
        AbstractGroupMember member = this.members.get(memberId);
        if (member != null) {
            this.election.onElection(member);
        }
    }
}

