/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.group.internal.MemberState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class MembersState
implements Iterable<MemberState>,
AutoCloseable {
    private final Map<String, MemberState> membersMap = new HashMap<String, MemberState>();
    private final List<MemberState> membersList = new ArrayList<MemberState>();

    MembersState() {
    }

    void add(MemberState member) {
        this.membersMap.put(member.id(), member);
        this.membersList.add(member);
    }

    MemberState get(String id) {
        return this.membersMap.get(id);
    }

    MemberState get(int index) {
        return this.membersList.get(index);
    }

    MemberState remove(String id) {
        MemberState member = this.membersMap.remove(id);
        if (member != null) {
            this.membersList.remove(member);
        }
        return member;
    }

    int size() {
        return this.membersList.size();
    }

    boolean isEmpty() {
        return this.membersList.isEmpty();
    }

    @Override
    public Iterator<MemberState> iterator() {
        return new MembersStateIterator(this.membersList.iterator());
    }

    @Override
    public void close() {
        this.membersList.forEach(MemberState::close);
    }

    private class MembersStateIterator
    implements Iterator<MemberState> {
        private final Iterator<MemberState> iterator;
        private MemberState member;

        private MembersStateIterator(Iterator<MemberState> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MemberState next() {
            this.member = this.iterator.next();
            return this.member;
        }

        @Override
        public void remove() {
            if (this.member != null) {
                this.iterator.remove();
                MembersState.this.membersMap.remove(this.member.id());
            }
        }
    }
}

