/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.catalyst.util.Assert;
import io.atomix.group.GroupMember;
import io.atomix.group.internal.GroupMemberInfo;
import io.atomix.group.internal.MembershipGroup;
import io.atomix.group.messaging.internal.AbstractMessageClient;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class AbstractGroupMember
implements GroupMember {
    protected final String memberId;
    protected final MembershipGroup group;
    protected final Object metadata;
    protected volatile GroupMember.Status status = GroupMember.Status.ALIVE;
    protected final Listeners<GroupMember.Status> statusListeners = new Listeners();

    public AbstractGroupMember(GroupMemberInfo info, MembershipGroup group) {
        this.memberId = info.memberId();
        this.group = Assert.notNull(group, "group");
        this.metadata = info.metadata();
    }

    @Override
    public String id() {
        return this.memberId;
    }

    @Override
    public GroupMember.Status status() {
        return this.status;
    }

    void onStatusChange(GroupMember.Status status) {
        if (this.status != status) {
            this.status = status;
            this.statusListeners.accept(status);
        }
    }

    @Override
    public Listener<GroupMember.Status> onStatusChange(Consumer<GroupMember.Status> callback) {
        return this.statusListeners.add(callback);
    }

    @Override
    public abstract AbstractMessageClient messaging();

    @Override
    public <T> Optional<T> metadata() {
        return this.metadata == null ? Optional.empty() : Optional.of(this.metadata);
    }
}

