/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.util;

import java.util.Map;
import java.util.TreeMap;

public final class TermIndex {
    private final TreeMap<Long, Long> terms = new TreeMap();

    public synchronized long term() {
        Map.Entry<Long, Long> entry = this.terms.lastEntry();
        return entry != null ? entry.getValue() : 0L;
    }

    public synchronized void index(long offset, long term) {
        if (this.lookup(offset) != term) {
            this.terms.put(offset, term);
        }
    }

    public synchronized long lookup(long offset) {
        Map.Entry<Long, Long> entry = this.terms.floorEntry(offset);
        return entry != null ? entry.getValue() : 0L;
    }

    public synchronized void truncate(long offset) {
        this.terms.tailMap(offset, false).clear();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

