/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.util.Assert;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SnapshotFile {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "snapshot";
    private final File file;

    public static boolean isSnapshotFile(String name, File file) {
        int i;
        Assert.notNull(name, "name");
        Assert.notNull(file, "file");
        String fileName = file.getName();
        if (fileName.lastIndexOf(46) == -1 || fileName.lastIndexOf(45) == -1 || fileName.lastIndexOf(46) < fileName.lastIndexOf(45) || !fileName.endsWith(EXTENSION)) {
            return false;
        }
        for (i = fileName.lastIndexOf(45) + 1; i < fileName.lastIndexOf(46); ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        if (fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1) == -1) {
            return false;
        }
        for (i = fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1) + 1; i < fileName.lastIndexOf(45); ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return fileName.substring(0, fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1)).equals(name);
    }

    static File createSnapshotFile(String name, File directory, long index, long timestamp) {
        return new File(directory, String.format("%s-%d-%s.snapshot", Assert.notNull(name, "name"), index, TIMESTAMP_FORMAT.format(new Date(timestamp))));
    }

    SnapshotFile(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public long index() {
        return Long.valueOf(this.file.getName().substring(this.file.getName().lastIndexOf(45, this.file.getName().lastIndexOf(45) - 1) + 1, this.file.getName().lastIndexOf(45)));
    }

    public long timestamp() {
        return Long.valueOf(this.file.getName().substring(this.file.getName().lastIndexOf(45) + 1, this.file.getName().lastIndexOf(46)));
    }
}

