/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.index;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.copycat.server.storage.index.OffsetIndex;
import io.atomix.copycat.server.storage.index.SearchableOffsetIndex;
import io.atomix.copycat.server.storage.index.SequentialOffsetIndex;

public class DelegatingOffsetIndex
implements OffsetIndex {
    private volatile OffsetIndex index;

    public DelegatingOffsetIndex(Buffer buffer) {
        this.index = new SequentialOffsetIndex(buffer);
    }

    @Override
    public long lastOffset() {
        return this.index.lastOffset();
    }

    @Override
    public boolean index(long offset, long position) {
        if (!this.index.index(offset, position)) {
            this.index = new SearchableOffsetIndex(this.index);
            return this.index.index(offset, position);
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public boolean contains(long offset) {
        return this.index.contains(offset);
    }

    @Override
    public long position(long offset) {
        return this.index.position(offset);
    }

    @Override
    public long find(long offset) {
        return this.index.find(offset);
    }

    @Override
    public long truncate(long offset) {
        return this.index.truncate(offset);
    }

    @Override
    public void flush() {
        this.index.flush();
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    public void delete() {
        this.index.delete();
    }
}

