/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class ConnectionManager {
    private final Client client;
    private final Map<Address, Connection> connections = new HashMap<Address, Connection>();
    private final Map<Address, CompletableFuture<Connection>> connectionFutures = new HashMap<Address, CompletableFuture<Connection>>();

    public ConnectionManager(Client client) {
        this.client = client;
    }

    public CompletableFuture<Connection> getConnection(Address address) {
        Connection connection = this.connections.get(address);
        return connection == null ? this.createConnection(address) : CompletableFuture.completedFuture(connection);
    }

    public void resetConnection(Address address) {
        Connection connection = this.connections.remove(address);
        if (connection != null) {
            connection.close();
        }
    }

    private CompletableFuture<Connection> createConnection(Address address) {
        return this.connectionFutures.computeIfAbsent(address, a -> {
            CompletionStage future = this.client.connect(address).thenApply(connection -> {
                connection.onClose(c -> this.connections.remove(address, c));
                this.connections.put(address, (Connection)connection);
                return connection;
            });
            ((CompletableFuture)future).whenComplete((connection, error) -> this.connectionFutures.remove(address));
            return future;
        });
    }

    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        for (CompletableFuture<Connection> future : this.connectionFutures.values()) {
            future.cancel(false);
        }
        int i = 0;
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        return CompletableFuture.allOf(futures);
    }
}

