/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public class PollResponse
extends AbstractResponse {
    private long term;
    private boolean accepted;

    public static Builder builder() {
        return new Builder(new PollResponse());
    }

    public static Builder builder(PollResponse response) {
        return new Builder(response);
    }

    public long term() {
        return this.term;
    }

    public boolean accepted() {
        return this.accepted;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.term = buffer.readLong();
            this.accepted = buffer.readBoolean();
        } else {
            this.error = CopycatError.forId(buffer.readByte());
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.term).writeBoolean(this.accepted);
        } else {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.term, this.accepted});
    }

    public boolean equals(Object object) {
        if (object instanceof PollResponse) {
            PollResponse response = (PollResponse)object;
            return response.status == this.status && response.term == this.term && response.accepted == this.accepted;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, error=%s, term=%d, accepted=%b]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.term, this.accepted});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, PollResponse> {
        protected Builder(PollResponse response) {
            super(response);
        }

        public Builder withTerm(long term) {
            ((PollResponse)this.response).term = Assert.argNot(term, term < 0L, "term must be positive", new Object[0]);
            return this;
        }

        public Builder withAccepted(boolean accepted) {
            ((PollResponse)this.response).accepted = accepted;
            return this;
        }

        @Override
        public PollResponse build() {
            super.build();
            if (((PollResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot(((PollResponse)this.response).term < 0L, "term must be positive", new Object[0]);
            }
            return (PollResponse)this.response;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.response);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Builder && ((PollResponse)((Builder)object).response).equals(this.response);
        }

        @Override
        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

