/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;

public class ConnectRequest
extends AbstractRequest {
    private String client;

    public static Builder builder() {
        return new Builder(new ConnectRequest());
    }

    public static Builder builder(ConnectRequest request) {
        return new Builder(request);
    }

    public String client() {
        return this.client;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = buffer.readString();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.client);
    }

    public boolean equals(Object object) {
        return object instanceof ConnectRequest && ((ConnectRequest)object).client.equals(this.client);
    }

    public String toString() {
        return String.format("%s[client=%s]", this.getClass().getSimpleName(), this.client);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, ConnectRequest> {
        protected Builder(ConnectRequest request) {
            super(request);
        }

        public Builder withClientId(String clientId) {
            ((ConnectRequest)this.request).client = Assert.notNull(clientId, "clientId");
            return this;
        }

        @Override
        public ConnectRequest build() {
            super.build();
            Assert.stateNot(((ConnectRequest)this.request).client == null, "client cannot be null", new Object[0]);
            return (ConnectRequest)this.request;
        }
    }
}

