/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public abstract class AbstractResponse
implements Response {
    protected Response.Status status = Response.Status.OK;
    protected CopycatError error;

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
    }

    @Override
    public Response.Status status() {
        return this.status;
    }

    @Override
    public CopycatError error() {
        return this.error;
    }

    public String toString() {
        return String.format("%s[status=%s, error=%s]", new Object[]{this.getClass().getCanonicalName(), this.status, this.error});
    }

    protected static abstract class Builder<T extends Builder<T, U>, U extends AbstractResponse>
    implements Response.Builder<T, U> {
        protected U response;

        protected Builder(U response) {
            this.response = response;
        }

        @Override
        public T withStatus(Response.Status status) {
            ((AbstractResponse)this.response).status = Assert.notNull(status, "status");
            return (T)this;
        }

        @Override
        public T withError(CopycatError error) {
            ((AbstractResponse)this.response).error = Assert.notNull(error, "error");
            return (T)this;
        }

        @Override
        public U build() {
            Assert.stateNot(((AbstractResponse)this.response).status == null, "status cannot be null", new Object[0]);
            return this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return this.getClass().isAssignableFrom(object.getClass()) && ((Builder)object).response.equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

