/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.util;

import io.atomix.catalyst.concurrent.Futures;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class OrderedCompletableFuture<T>
extends CompletableFuture<T> {
    private final Queue<CompletableFuture<T>> orderedFutures = new LinkedList<CompletableFuture<T>>();
    private boolean complete;
    private T result;
    private Throwable error;

    public OrderedCompletableFuture() {
        super.whenComplete(this::complete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<T> orderedFuture() {
        Queue<CompletableFuture<T>> queue = this.orderedFutures;
        synchronized (queue) {
            if (this.complete) {
                if (this.error == null) {
                    return CompletableFuture.completedFuture(this.result);
                }
                return Futures.exceptionalFuture(this.error);
            }
            CompletableFuture future = new CompletableFuture();
            this.orderedFutures.add(future);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(T result, Throwable error) {
        Queue<CompletableFuture<T>> queue = this.orderedFutures;
        synchronized (queue) {
            this.complete = true;
            this.result = result;
            this.error = error;
            if (error == null) {
                for (CompletableFuture completableFuture : this.orderedFutures) {
                    completableFuture.complete(result);
                }
            } else {
                for (CompletableFuture completableFuture : this.orderedFutures) {
                    completableFuture.completeExceptionally(error);
                }
            }
        }
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.orderedFuture().thenApply(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.orderedFuture().thenApplyAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.orderedFuture().thenApplyAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.orderedFuture().thenAccept((Consumer)action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.orderedFuture().thenAcceptAsync((Consumer)action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.orderedFuture().thenAcceptAsync((Consumer)action, executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.orderedFuture().thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.orderedFuture().thenRunAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.orderedFuture().thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.orderedFuture().thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.orderedFuture().thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.orderedFuture().thenCombineAsync(other, fn, executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.orderedFuture().thenAcceptBoth(other, (BiConsumer)action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.orderedFuture().thenAcceptBothAsync(other, (BiConsumer)action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.orderedFuture().thenAcceptBothAsync(other, (BiConsumer)action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.orderedFuture().runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.orderedFuture().runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.orderedFuture().runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.orderedFuture().applyToEither((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.orderedFuture().applyToEitherAsync((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.orderedFuture().applyToEitherAsync((CompletionStage)other, fn, executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.orderedFuture().acceptEither((CompletionStage)other, (Consumer)action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.orderedFuture().acceptEitherAsync((CompletionStage)other, (Consumer)action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.orderedFuture().acceptEitherAsync((CompletionStage)other, (Consumer)action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.orderedFuture().runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.orderedFuture().runAfterEitherAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.orderedFuture().runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.orderedFuture().thenCompose(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.orderedFuture().thenComposeAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.orderedFuture().thenComposeAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.orderedFuture().whenComplete(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.orderedFuture().whenCompleteAsync(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.orderedFuture().whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.orderedFuture().handle(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.orderedFuture().handleAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.orderedFuture().handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.orderedFuture().exceptionally(fn);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }
}

