/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.catalyst.concurrent.BlockingFuture;
import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.client.session.ClientSession;
import io.atomix.copycat.client.util.AddressSelector;
import io.atomix.copycat.session.ClosedSessionException;
import io.atomix.copycat.session.Session;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCopycatClient
implements CopycatClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCopycatClient.class);
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final int DEFAULT_PORT = 8700;
    private final String clientId;
    private final Collection<Address> cluster;
    private final Transport transport;
    private final ThreadContext ioContext;
    private final ThreadContext eventContext;
    private final AddressSelector selector;
    private final Duration sessionTimeout;
    private final Duration unstabilityTimeout;
    private final ConnectionStrategy connectionStrategy;
    private final RecoveryStrategy recoveryStrategy;
    private ClientSession session;
    private volatile CopycatClient.State state = CopycatClient.State.CLOSED;
    private volatile CompletableFuture<CopycatClient> openFuture;
    private volatile CompletableFuture<CopycatClient> recoverFuture;
    private volatile CompletableFuture<Void> closeFuture;
    private final Set<StateChangeListener> changeListeners = new CopyOnWriteArraySet<StateChangeListener>();
    private final Set<EventListener<?>> eventListeners = new CopyOnWriteArraySet();
    private Listener<Session.State> changeListener;

    DefaultCopycatClient(String clientId, Collection<Address> cluster, Transport transport, ThreadContext ioContext, ThreadContext eventContext, ServerSelectionStrategy selectionStrategy, ConnectionStrategy connectionStrategy, RecoveryStrategy recoveryStrategy, Duration sessionTimeout, Duration unstabilityTimeout) {
        this.clientId = Assert.notNull(clientId, "clientId");
        this.cluster = Assert.notNull(cluster, "cluster");
        this.transport = Assert.notNull(transport, "transport");
        this.ioContext = Assert.notNull(ioContext, "ioContext");
        this.eventContext = Assert.notNull(eventContext, "eventContext");
        this.selector = new AddressSelector(selectionStrategy);
        this.connectionStrategy = Assert.notNull(connectionStrategy, "connectionStrategy");
        this.recoveryStrategy = Assert.notNull(recoveryStrategy, "recoveryStrategy");
        this.sessionTimeout = Assert.notNull(sessionTimeout, "sessionTimeout");
        this.unstabilityTimeout = Assert.notNull(unstabilityTimeout, "unstabilityTimeout");
    }

    @Override
    public CopycatClient.State state() {
        return this.state;
    }

    private void setState(CopycatClient.State state) {
        if (this.state != state) {
            this.state = state;
            LOGGER.debug("State changed: {}", (Object)state);
            this.changeListeners.forEach(l -> l.accept(state));
        }
    }

    @Override
    public Listener<CopycatClient.State> onStateChange(Consumer<CopycatClient.State> callback) {
        return new StateChangeListener(callback);
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public Serializer serializer() {
        ThreadContext context = ThreadContext.currentContext();
        return context != null ? context.serializer() : this.eventContext.serializer();
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public ThreadContext context() {
        return this.eventContext;
    }

    private ClientSession newSession() {
        ClientSession session = new ClientSession(this.clientId, this.transport.client(), this.selector, this.ioContext, this.connectionStrategy, this.sessionTimeout, this.unstabilityTimeout);
        if (this.changeListener != null) {
            this.changeListener.close();
        }
        this.changeListener = session.onStateChange(this::onStateChange);
        this.eventListeners.forEach(l -> l.register(session));
        return session;
    }

    private void onStateChange(Session.State state) {
        switch (state) {
            case OPEN: {
                this.setState(CopycatClient.State.CONNECTED);
                break;
            }
            case UNSTABLE: {
                this.setState(CopycatClient.State.SUSPENDED);
                break;
            }
            case STALE: {
                this.setState(CopycatClient.State.SUSPENDED);
                this.close();
                break;
            }
            case EXPIRED: {
                this.setState(CopycatClient.State.SUSPENDED);
                this.recoveryStrategy.recover(this);
                break;
            }
            case CLOSED: {
                this.setState(CopycatClient.State.CLOSED);
                break;
            }
        }
    }

    @Override
    public synchronized CompletableFuture<CopycatClient> connect(Collection<Address> cluster) {
        if (this.state != CopycatClient.State.CLOSED) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            this.openFuture = new CompletableFuture();
            if (cluster == null || cluster.isEmpty()) {
                cluster = this.cluster;
            }
            if (cluster == null || cluster.isEmpty()) {
                cluster = Collections.singletonList(new Address(DEFAULT_HOST, 8700));
            }
            this.selector.reset(null, cluster);
            this.session = this.newSession();
            this.session.register().whenCompleteAsync((result, error) -> {
                if (error == null) {
                    this.openFuture.complete(this);
                } else {
                    this.openFuture.completeExceptionally((Throwable)error);
                }
            }, this.eventContext.executor());
        }
        return this.openFuture;
    }

    @Override
    public <T> CompletableFuture<T> submit(Command<T> command) {
        ClientSession session = this.session;
        if (session == null) {
            return Futures.exceptionalFuture(new ClosedSessionException("session closed"));
        }
        BlockingFuture future = new BlockingFuture();
        session.submit(command).whenComplete((result, error) -> {
            if (this.eventContext.isBlocked()) {
                future.accept(result, (Throwable)error);
            } else {
                this.eventContext.executor().execute(() -> future.accept(result, (Throwable)error));
            }
        });
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(Query<T> query) {
        ClientSession session = this.session;
        if (session == null) {
            return Futures.exceptionalFuture(new ClosedSessionException("session closed"));
        }
        BlockingFuture future = new BlockingFuture();
        session.submit(query).whenComplete((result, error) -> {
            if (this.eventContext.isBlocked()) {
                future.accept(result, (Throwable)error);
            } else {
                this.eventContext.executor().execute(() -> future.accept(result, (Throwable)error));
            }
        });
        return future;
    }

    @Override
    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.onEvent(event, (T v) -> callback.run());
    }

    @Override
    public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
        EventListener listener = new EventListener(event, callback);
        listener.register(this.session);
        return listener;
    }

    @Override
    public synchronized CompletableFuture<CopycatClient> recover() {
        if (this.recoverFuture == null) {
            LOGGER.debug("Recovering session {}", (Object)this.session.id());
            this.recoverFuture = new CompletableFuture();
            this.session.close().whenCompleteAsync((closeResult, closeError) -> {
                this.session = this.newSession();
                this.session.register().whenCompleteAsync((registerResult, registerError) -> {
                    CompletableFuture<CopycatClient> recoverFuture = this.recoverFuture;
                    if (registerError == null) {
                        recoverFuture.complete(this);
                    } else {
                        recoverFuture.completeExceptionally((Throwable)registerError);
                    }
                    this.recoverFuture = null;
                }, this.eventContext.executor());
            }, this.eventContext.executor());
        }
        return this.recoverFuture;
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        if (this.state == CopycatClient.State.CLOSED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            this.closeFuture = new CompletableFuture();
            this.session.close().whenCompleteAsync((result, error) -> {
                this.setState(CopycatClient.State.CLOSED);
                CompletableFuture.runAsync(() -> {
                    this.ioContext.close();
                    this.eventContext.close();
                    this.transport.close();
                    if (error == null) {
                        this.closeFuture.complete(null);
                    } else {
                        this.closeFuture.completeExceptionally((Throwable)error);
                    }
                });
            }, this.eventContext.executor());
        }
        return this.closeFuture;
    }

    public synchronized CompletableFuture<Void> kill() {
        if (this.state == CopycatClient.State.CLOSED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            this.closeFuture = this.session.kill().whenComplete((result, error) -> {
                this.setState(CopycatClient.State.CLOSED);
                CompletableFuture.runAsync(() -> {
                    this.ioContext.close();
                    this.eventContext.close();
                    this.transport.close();
                });
            });
        }
        return this.closeFuture;
    }

    public int hashCode() {
        return 23 + 37 * (this.session != null ? this.session.hashCode() : 0);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultCopycatClient && ((DefaultCopycatClient)object).session() == this.session;
    }

    public String toString() {
        return String.format("%s[session=%s]", this.getClass().getSimpleName(), this.session);
    }

    private final class EventListener<T>
    implements Listener<T> {
        private final String event;
        private final Consumer<T> callback;
        private Listener<T> parent;

        private EventListener(String event, Consumer<T> callback) {
            this.event = event;
            this.callback = callback;
            DefaultCopycatClient.this.eventListeners.add(this);
        }

        public void register(ClientSession session) {
            this.parent = session.onEvent(this.event, this);
        }

        @Override
        public void accept(T message) {
            if (DefaultCopycatClient.this.eventContext.isBlocked()) {
                this.callback.accept(message);
            } else {
                DefaultCopycatClient.this.eventContext.executor().execute(() -> this.callback.accept(message));
            }
        }

        @Override
        public void close() {
            this.parent.close();
            DefaultCopycatClient.this.eventListeners.remove(this);
        }
    }

    private final class StateChangeListener
    implements Listener<CopycatClient.State> {
        private final Consumer<CopycatClient.State> callback;

        protected StateChangeListener(Consumer<CopycatClient.State> callback) {
            this.callback = callback;
            DefaultCopycatClient.this.changeListeners.add(this);
        }

        @Override
        public void accept(CopycatClient.State state) {
            DefaultCopycatClient.this.eventContext.executor().execute(() -> this.callback.accept(state));
        }

        @Override
        public void close() {
            DefaultCopycatClient.this.changeListeners.remove(this);
        }
    }
}

