/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.concurrent.internal;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.concurrent.internal.LockCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;

public class LockState
extends ResourceStateMachine
implements SessionListener {
    private Commit<LockCommands.Lock> lock;
    private final Queue<Commit<LockCommands.Lock>> queue = new ArrayDeque<Commit<LockCommands.Lock>>();
    private final Map<Long, Scheduled> timers = new HashMap<Long, Scheduled>();

    public LockState(Properties config) {
        super(config);
    }

    @Override
    public void close(ServerSession session) {
        if (this.lock != null && this.lock.session().id() == session.id()) {
            this.lock.close();
            this.lock = this.queue.poll();
            while (this.lock != null) {
                Scheduled timer = this.timers.remove(this.lock.index());
                if (timer != null) {
                    timer.cancel();
                }
                if (this.lock.session().state() == Session.State.EXPIRED || this.lock.session().state() == Session.State.CLOSED) {
                    this.lock = this.queue.poll();
                    continue;
                }
                this.lock.session().publish("lock", new LockCommands.LockEvent(this.lock.operation().id(), this.lock.index()));
                break;
            }
        }
    }

    public void lock(Commit<LockCommands.Lock> commit) {
        if (this.lock == null) {
            this.lock = commit;
            commit.session().publish("lock", new LockCommands.LockEvent(commit.operation().id(), commit.index()));
        } else if (commit.operation().timeout() == 0L) {
            try {
                commit.session().publish("fail", new LockCommands.LockEvent(commit.operation().id(), commit.index()));
            }
            finally {
                commit.close();
            }
        } else {
            this.queue.add(commit);
            if (commit.operation().timeout() > 0L) {
                this.timers.put(commit.index(), this.executor.schedule(Duration.ofMillis(commit.operation().timeout()), () -> {
                    try {
                        this.timers.remove(commit.index());
                        this.queue.remove(commit);
                        if (commit.session().state().active()) {
                            commit.session().publish("fail", new LockCommands.LockEvent(((LockCommands.Lock)commit.operation()).id(), commit.index()));
                        }
                    }
                    finally {
                        commit.close();
                    }
                }));
            }
        }
    }

    public void unlock(Commit<LockCommands.Unlock> commit) {
        block8: {
            try {
                if (this.lock == null) break block8;
                if (!this.lock.session().equals(commit.session())) {
                    return;
                }
                this.lock.close();
                this.lock = this.queue.poll();
                while (this.lock != null) {
                    Scheduled timer = this.timers.remove(this.lock.index());
                    if (timer != null) {
                        timer.cancel();
                    }
                    if (this.lock.session().state() == Session.State.EXPIRED || this.lock.session().state() == Session.State.CLOSED) {
                        this.lock = this.queue.poll();
                        continue;
                    }
                    this.lock.session().publish("lock", new LockCommands.LockEvent(this.lock.operation().id(), this.lock.index()));
                    break;
                }
            }
            finally {
                commit.close();
            }
        }
    }

    @Override
    public void delete() {
        if (this.lock != null) {
            this.lock.close();
        }
        this.queue.forEach(Commit::close);
        this.queue.clear();
        this.timers.values().forEach(Scheduled::cancel);
        this.timers.clear();
    }
}

