/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.collections.DistributedSet;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Set;

public class SetCommands {
    private SetCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Contains.class, -100);
            registry.register(Add.class, -101);
            registry.register(Remove.class, -102);
            registry.register(IsEmpty.class, -103);
            registry.register(Size.class, -104);
            registry.register(Clear.class, -105);
            registry.register(Iterator.class, -106);
            registry.register(DistributedSet.ValueEvent.class, -48);
        }
    }

    public static class Clear
    extends SetCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Iterator<V>
    extends SetQuery<Set<V>> {
    }

    public static class IsEmpty
    extends SetQuery<Boolean> {
        public IsEmpty() {
        }

        public IsEmpty(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class Size
    extends SetQuery<Integer> {
        public Size() {
        }

        public Size(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class Remove
    extends ValueCommand<Boolean> {
        public Remove() {
        }

        public Remove(Object value) {
            super(value);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Add
    extends TtlCommand<Boolean> {
        public Add() {
        }

        public Add(Object value) {
            super(value, 0L);
        }

        public Add(Object value, long ttl) {
            super(value, ttl);
        }
    }

    public static abstract class TtlCommand<V>
    extends ValueCommand<V> {
        protected long ttl;

        protected TtlCommand() {
        }

        protected TtlCommand(Object value, long ttl) {
            super(value);
            this.ttl = ttl;
        }

        @Override
        public Command.CompactionMode compaction() {
            return this.ttl > 0L ? Command.CompactionMode.EXPIRING : Command.CompactionMode.QUORUM;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.ttl = buffer.readLong();
        }
    }

    public static class Contains
    extends ValueQuery<Boolean> {
        public Contains() {
        }

        public Contains(Object value) {
            super(value);
        }

        public Contains(Object value, Query.ConsistencyLevel consistency) {
            super(value, consistency);
        }
    }

    private static abstract class ValueQuery<V>
    extends SetQuery<V> {
        protected Object value;

        public ValueQuery() {
        }

        public ValueQuery(Object value) {
            this.value = value;
        }

        public ValueQuery(Object value, Query.ConsistencyLevel consistency) {
            super(consistency);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class ValueCommand<V>
    extends SetCommand<V> {
        protected Object value;

        public ValueCommand() {
        }

        public ValueCommand(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }
    }

    private static abstract class SetQuery<V>
    implements Query<V>,
    CatalystSerializable {
        protected Query.ConsistencyLevel consistency;

        protected SetQuery() {
        }

        protected SetQuery(Query.ConsistencyLevel consistency) {
            this.consistency = consistency;
        }

        @Override
        public void writeObject(BufferOutput<?> output, Serializer serializer) {
            if (this.consistency != null) {
                output.writeByte(this.consistency.ordinal());
            } else {
                output.writeByte(-1);
            }
        }

        @Override
        public void readObject(BufferInput<?> input, Serializer serializer) {
            int ordinal = input.readByte();
            if (ordinal != -1) {
                this.consistency = Query.ConsistencyLevel.values()[ordinal];
            }
        }
    }

    private static abstract class SetCommand<V>
    implements Command<V>,
    CatalystSerializable {
        private SetCommand() {
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

