/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import java.net.InetSocketAddress;

public class Address
implements CatalystSerializable {
    private String host;
    private int port;
    private InetSocketAddress address;

    public Address() {
    }

    public Address(String address) {
        Assert.notNull(address, "address");
        String[] components = address.split(":");
        Assert.arg(components.length == 2, "%s must contain address:port", address);
        this.host = components[0];
        try {
            this.port = Integer.parseInt(components[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(components[1] + " is not a number");
        }
        this.address = new InetSocketAddress(this.host, this.port);
    }

    public Address(Address address) {
        this(address.host, address.port, Assert.notNull(address, (String)"address").address);
    }

    public Address(String host, int port) {
        this(host, port, new InetSocketAddress(host, port));
    }

    public Address(InetSocketAddress address) {
        this(address.getHostName(), address.getPort(), address);
    }

    private Address(String host, int port, InetSocketAddress address) {
        this.host = Assert.notNull(host, "host");
        this.port = port;
        this.address = Assert.notNull(address, "address");
    }

    public String host() {
        return this.address.getHostString();
    }

    public int port() {
        return this.address.getPort();
    }

    public InetSocketAddress socketAddress() {
        return this.address;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUTF8(this.host()).writeInt(this.port());
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.address = new InetSocketAddress(buffer.readUTF8(), buffer.readInt());
    }

    public boolean equals(Object object) {
        return object instanceof Address && ((Address)object).address.equals(this.address);
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + this.address.hashCode();
        return hashCode;
    }

    public String toString() {
        return this.address.toString();
    }
}

