/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.buffer.BufferAllocator;
import io.atomix.catalyst.buffer.UnpooledUnsafeHeapAllocator;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.PropertiesReader;
import java.util.Map;
import java.util.Properties;

final class SerializerOptions {
    private static final String WHITELIST = "whitelist";
    private static final String ALLOCATOR = "allocator";
    private static final String TYPES = "types";
    private static final String SERIALIZERS = "serializers";
    private static final String ABSTRACT_SERIALIZERS = "abstractSerializers";
    private static final String DEFAULT_SERIALIZERS = "defaultSerializers";
    private final PropertiesReader reader;

    public SerializerOptions(Properties properties) {
        this.reader = new PropertiesReader(properties);
    }

    boolean whitelist() {
        return this.reader.getBoolean(WHITELIST, false);
    }

    BufferAllocator allocator() {
        Class<?> allocator = this.reader.getClass(ALLOCATOR, UnpooledUnsafeHeapAllocator.class);
        try {
            return (BufferAllocator)allocator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException(e);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("invalid allocator class: " + allocator.getName(), new Object[0]);
        }
    }

    Map<Integer, Class<?>> types() {
        return this.reader.getMap(TYPES, this::idToInt, this::typeToClass);
    }

    Map<Integer, Class<?>> serializers() {
        return this.reader.getMap(SERIALIZERS, this::idToInt, this::serializerToClass);
    }

    Map<Integer, Class<?>> abstractSerializers() {
        return this.reader.getMap(ABSTRACT_SERIALIZERS, this::idToInt, this::serializerToClass);
    }

    Map<Integer, Class<?>> defaultSerializers() {
        return this.reader.getMap(DEFAULT_SERIALIZERS, this::idToInt, this::serializerToClass);
    }

    private int idToInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("invalid type ID: " + value, new Object[0]);
        }
    }

    private Class<?> serializerToClass(String value) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(value);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("unknown serializable type: " + value, new Object[0]);
        }
    }

    private Class<?> typeToClass(String value) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(value);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("unknown serializable type: " + value, new Object[0]);
        }
    }
}

