/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;

enum Identifier {
    INT8(1){

        @Override
        public boolean accept(int id) {
            return id >= -128 && id <= 127;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeByte(id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readByte();
        }
    }
    ,
    UINT8(2){

        @Override
        public boolean accept(int id) {
            return id >= 0 && id <= 255;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeUnsignedByte(id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readUnsignedByte();
        }
    }
    ,
    INT16(3){

        @Override
        public boolean accept(int id) {
            return id >= Short.MIN_VALUE && id <= Short.MAX_VALUE;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeShort((short)id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readShort();
        }
    }
    ,
    UINT16(4){

        @Override
        public boolean accept(int id) {
            return id >= 0 && id <= 65535;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeUnsignedShort(id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readUnsignedShort();
        }
    }
    ,
    INT24(5){

        @Override
        public boolean accept(int id) {
            return id >= 0x800000 && id <= 0x7FFFFF;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeMedium(id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readMedium();
        }
    }
    ,
    UINT24(6){

        @Override
        public boolean accept(int id) {
            return id >= 0 && id <= 0xFFFFFF;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeUnsignedMedium(id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readUnsignedMedium();
        }
    }
    ,
    INT32(7){

        @Override
        public boolean accept(int id) {
            return true;
        }

        @Override
        public void write(int id, BufferOutput output) {
            output.writeInt(id);
        }

        @Override
        public int read(BufferInput input) {
            return input.readInt();
        }
    }
    ,
    NULL(0){

        @Override
        public boolean accept(int id) {
            return false;
        }

        @Override
        public void write(int id, BufferOutput output) {
        }

        @Override
        public int read(BufferInput input) {
            return 0;
        }
    }
    ,
    CLASS(8){

        @Override
        public boolean accept(int id) {
            return false;
        }

        @Override
        public void write(int id, BufferOutput output) {
        }

        @Override
        public int read(BufferInput input) {
            return 0;
        }
    };

    private final int code;

    private Identifier(int code) {
        this.code = code;
    }

    public static Identifier forCode(int code) {
        switch (code) {
            case 1: {
                return INT8;
            }
            case 2: {
                return UINT8;
            }
            case 3: {
                return INT16;
            }
            case 4: {
                return UINT16;
            }
            case 5: {
                return INT24;
            }
            case 6: {
                return UINT24;
            }
            case 7: {
                return INT32;
            }
            case 0: {
                return NULL;
            }
            case 8: {
                return CLASS;
            }
        }
        throw new IllegalArgumentException("invalid code: " + code);
    }

    public int code() {
        return this.code;
    }

    public abstract boolean accept(int var1);

    public abstract void write(int var1, BufferOutput var2);

    public abstract int read(BufferInput var1);
}

