/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.concurrent;

import io.atomix.catalyst.concurrent.ComposableFuture;
import io.atomix.catalyst.concurrent.ThreadContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingFuture<T>
extends ComposableFuture<T> {
    @Override
    public T get() throws InterruptedException, ExecutionException {
        ThreadContext context = ThreadContext.currentContext();
        if (context != null) {
            context.block();
            try {
                Object t = super.get();
                return t;
            }
            finally {
                context.unblock();
            }
        }
        return super.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ThreadContext context = ThreadContext.currentContext();
        if (context != null) {
            context.block();
            try {
                Object t = super.get(timeout, unit);
                return t;
            }
            finally {
                context.unblock();
            }
        }
        return super.get(timeout, unit);
    }

    @Override
    public T join() {
        ThreadContext context = ThreadContext.currentContext();
        if (context != null) {
            context.block();
            try {
                Object t = super.join();
                return t;
            }
            finally {
                context.unblock();
            }
        }
        return super.join();
    }
}

