/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.NativeBuffer;
import io.atomix.catalyst.buffer.UnsafeMappedBytes;
import io.atomix.catalyst.buffer.util.MappedMemory;
import io.atomix.catalyst.buffer.util.MappedMemoryAllocator;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.util.reference.ReferenceManager;
import java.io.File;
import java.nio.channels.FileChannel;

public class UnsafeMappedBuffer
extends NativeBuffer {
    private static final long DEFAULT_INITIAL_CAPACITY = 0x1000000L;

    public static UnsafeMappedBuffer allocate(File file) {
        return UnsafeMappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, 0x1000000L, Long.MAX_VALUE);
    }

    public static UnsafeMappedBuffer allocate(File file, FileChannel.MapMode mode) {
        return UnsafeMappedBuffer.allocate(file, mode, 0x1000000L, Long.MAX_VALUE);
    }

    public static UnsafeMappedBuffer allocate(File file, long capacity) {
        return UnsafeMappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, capacity, capacity);
    }

    public static UnsafeMappedBuffer allocate(File file, FileChannel.MapMode mode, long capacity) {
        return UnsafeMappedBuffer.allocate(file, mode, capacity, capacity);
    }

    public static UnsafeMappedBuffer allocate(File file, long initialCapacity, long maxCapacity) {
        return UnsafeMappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, initialCapacity, maxCapacity);
    }

    public static UnsafeMappedBuffer allocate(File file, FileChannel.MapMode mode, long initialCapacity, long maxCapacity) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = MappedMemoryAllocator.DEFAULT_MAP_MODE;
        }
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        if (initialCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("initial capacity for MappedBuffer cannot be greater than 2147483647");
        }
        if (maxCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maximum capacity for MappedBuffer cannot be greater than 2147483647");
        }
        return new UnsafeMappedBuffer(new UnsafeMappedBytes(file, MappedMemory.allocate(file, mode, Memory.Util.toPow2(initialCapacity))), 0L, initialCapacity, maxCapacity);
    }

    protected UnsafeMappedBuffer(UnsafeMappedBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }

    UnsafeMappedBuffer(UnsafeMappedBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity);
    }

    public void delete() {
        ((UnsafeMappedBytes)this.bytes).delete();
    }
}

