/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBuffer;
import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.UnsafeHeapBytes;
import io.atomix.catalyst.buffer.util.HeapMemory;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class UnsafeHeapBuffer
extends AbstractBuffer {
    private final UnsafeHeapBytes bytes;

    public static UnsafeHeapBuffer allocate() {
        return UnsafeHeapBuffer.allocate(4096L, Integer.MAX_VALUE);
    }

    public static UnsafeHeapBuffer allocate(long initialCapacity) {
        return UnsafeHeapBuffer.allocate(initialCapacity, Integer.MAX_VALUE);
    }

    public static UnsafeHeapBuffer allocate(long initialCapacity, long maxCapacity) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        if (initialCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("initial capacity for HeapBuffer cannot be greater than 2147483647");
        }
        if (maxCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maximum capacity for HeapBuffer cannot be greater than 2147483647");
        }
        return new UnsafeHeapBuffer(new UnsafeHeapBytes(HeapMemory.allocate(Memory.Util.toPow2(initialCapacity))), 0L, initialCapacity, maxCapacity);
    }

    public static UnsafeHeapBuffer wrap(byte[] bytes) {
        return new UnsafeHeapBuffer(UnsafeHeapBytes.wrap(bytes), 0L, bytes.length, bytes.length);
    }

    protected UnsafeHeapBuffer(UnsafeHeapBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.bytes = bytes;
    }

    protected UnsafeHeapBuffer(UnsafeHeapBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.bytes = bytes;
    }

    @Override
    protected void compact(long from, long to, long length) {
        this.bytes.memory.unsafe().copyMemory(this.bytes.memory.array(), this.bytes.memory.address(from), this.bytes.memory.array(), this.bytes.memory.address(to), length);
        this.bytes.memory.unsafe().setMemory(this.bytes.memory.array(), this.bytes.memory.address(from), length, (byte)0);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.bytes.memory.array();
    }

    public UnsafeHeapBuffer reset(byte[] array) {
        this.bytes.memory.reset(array);
        this.clear();
        return this;
    }
}

