/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.collections.DistributedMap;
import io.atomix.collections.DistributedMultiMap;
import io.atomix.collections.DistributedQueue;
import io.atomix.collections.DistributedSet;
import io.atomix.concurrent.DistributedLock;
import io.atomix.group.DistributedGroup;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.ResourceManager;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import io.atomix.variables.DistributedValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public abstract class Atomix
implements ResourceManager<Atomix> {
    static final Collection<ResourceType> RESOURCES = Arrays.asList(new ResourceType(DistributedMap.class), new ResourceType(DistributedMultiMap.class), new ResourceType(DistributedSet.class), new ResourceType(DistributedQueue.class), new ResourceType(DistributedValue.class), new ResourceType(DistributedLong.class), new ResourceType(DistributedLock.class), new ResourceType(DistributedGroup.class));
    final ResourceClient client;

    protected Atomix(ResourceClient client) {
        this.client = Assert.notNull(client, "client");
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public Serializer serializer() {
        return this.client.client().serializer();
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key) {
        return this.getResource(key, DistributedMap.class);
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key, Resource.Config config) {
        return this.getResource(key, DistributedMap.class, config);
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key, DistributedMap.Options options) {
        return this.getResource(key, DistributedMap.class, (Resource.Options)options);
    }

    public <K, V> CompletableFuture<DistributedMap<K, V>> getMap(String key, Resource.Config config, DistributedMap.Options options) {
        return this.getResource(key, DistributedMap.class, config, (Resource.Options)options);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key) {
        return this.getResource(key, DistributedMultiMap.class);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key, DistributedMultiMap.Config config) {
        return this.getResource(key, DistributedMultiMap.class, (Resource.Config)config);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key, Resource.Options options) {
        return this.getResource(key, DistributedMultiMap.class, options);
    }

    public <K, V> CompletableFuture<DistributedMultiMap<K, V>> getMultiMap(String key, DistributedMultiMap.Config config, Resource.Options options) {
        return this.getResource(key, DistributedMultiMap.class, (Resource.Config)config, options);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key) {
        return this.getResource(key, DistributedSet.class);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key, Resource.Config config) {
        return this.getResource(key, DistributedSet.class, config);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key, Resource.Options options) {
        return this.getResource(key, DistributedSet.class, options);
    }

    public <T> CompletableFuture<DistributedSet<T>> getSet(String key, Resource.Config config, Resource.Options options) {
        return this.getResource(key, DistributedSet.class, config, options);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key) {
        return this.getResource(key, DistributedQueue.class);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key, Resource.Config config) {
        return this.getResource(key, DistributedQueue.class, config);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key, Resource.Options options) {
        return this.getResource(key, DistributedQueue.class, options);
    }

    public <T> CompletableFuture<DistributedQueue<T>> getQueue(String key, Resource.Config config, Resource.Options options) {
        return this.getResource(key, DistributedQueue.class, config, options);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key) {
        return this.getResource(key, DistributedValue.class);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key, Resource.Config config) {
        return this.getResource(key, DistributedValue.class, config);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key, Resource.Options options) {
        return this.getResource(key, DistributedValue.class, options);
    }

    public <T> CompletableFuture<DistributedValue<T>> getValue(String key, Resource.Config config, Resource.Options options) {
        return this.getResource(key, DistributedValue.class, config, options);
    }

    public CompletableFuture<DistributedLong> getLong(String key) {
        return this.getResource(key, DistributedLong.class);
    }

    public CompletableFuture<DistributedLong> getLong(String key, Resource.Config config) {
        return this.getResource(key, DistributedLong.class, config);
    }

    public CompletableFuture<DistributedLong> getLong(String key, Resource.Options options) {
        return this.getResource(key, DistributedLong.class, options);
    }

    public CompletableFuture<DistributedLong> getLong(String key, Resource.Config config, Resource.Options options) {
        return this.getResource(key, DistributedLong.class, config, options);
    }

    public CompletableFuture<DistributedLock> getLock(String key) {
        return this.getResource(key, DistributedLock.class);
    }

    public CompletableFuture<DistributedLock> getLock(String key, Resource.Config config) {
        return this.getResource(key, DistributedLock.class, config);
    }

    public CompletableFuture<DistributedLock> getLock(String key, Resource.Options options) {
        return this.getResource(key, DistributedLock.class, options);
    }

    public CompletableFuture<DistributedLock> getLock(String key, Resource.Config config, Resource.Options options) {
        return this.getResource(key, DistributedLock.class, config, options);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key) {
        return this.getResource(key, DistributedGroup.class);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key, DistributedGroup.Config config) {
        return this.getResource(key, DistributedGroup.class, (Resource.Config)config);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key, DistributedGroup.Options options) {
        return this.getResource(key, DistributedGroup.class, (Resource.Options)options);
    }

    public CompletableFuture<DistributedGroup> getGroup(String key, DistributedGroup.Config config, DistributedGroup.Options options) {
        return this.getResource(key, DistributedGroup.class, (Resource.Config)config, (Resource.Options)options);
    }

    @Override
    public ResourceType type(Class<? extends Resource<?>> type) {
        return this.client.type(type);
    }

    @Override
    public CompletableFuture<Boolean> exists(String key) {
        return this.client.exists(key);
    }

    @Override
    public CompletableFuture<Set<String>> keys() {
        return this.client.keys().thenApply(this::cleanKeys);
    }

    @Override
    public <T extends Resource> CompletableFuture<Set<String>> keys(Class<? super T> type) {
        return this.client.keys(type).thenApply(this::cleanKeys);
    }

    @Override
    public CompletableFuture<Set<String>> keys(ResourceType type) {
        return this.client.keys(type).thenApply(this::cleanKeys);
    }

    private Set<String> cleanKeys(Set<String> keys) {
        keys.remove("");
        return keys;
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, new Resource.Config(), new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Config config) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, config, new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, new Resource.Config(), options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Config config, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, config, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, new Resource.Config(), new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Config config) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, config, new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, new Resource.Config(), options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Config config, Resource.Options options) {
        Assert.argNot(key.trim().length() == 0, "invalid resource key: key must be of non-zero length", new Object[0]);
        return this.client.getResource(key, type, config, options);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

