/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.tools;

import javax.xml.bind.DatatypeConverter;

public abstract class PcepTools {
    private PcepTools() {
    }

    public static String toHexString(byte[] byteArray) {
        return DatatypeConverter.printHexBinary((byte[])byteArray);
    }

    public static byte[] toByteArray(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }

    public static String toDecimalString(byte[] bytes) {
        String str = "";
        for (int i = 0; i < bytes.length; ++i) {
            str = str + String.valueOf(bytes[i]);
        }
        return str;
    }

    public static String stringToIp(String str) {
        long ipInt = Long.parseLong(str, 16);
        return PcepTools.longToIp(ipInt);
    }

    public static String longToIp(long ipLong) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipLong >> 24 & 0xFFL).append(".");
        sb.append(ipLong >> 16 & 0xFFL).append(".");
        sb.append(ipLong >> 8 & 0xFFL).append(".");
        sb.append(ipLong & 0xFFL);
        return sb.toString();
    }

    public static long ipToLong(String strIp) {
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static int tranferHexStringToInt(String str, int base, int offset) {
        return Integer.parseInt(str.substring(base, offset), 16);
    }
}

