/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.api;

import org.onosproject.net.LinkKey;
import org.onosproject.net.config.Config;

public class TeLinkConfig
extends Config<LinkKey> {
    public static final String MAX_RESV_BW = "maxRervableBandwidth";
    public static final String UNRESV_BWS = "unReservedBandwidths";
    public static final String IGP_COST = "igpCost";
    public static final String TE_COST = "teCost";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{MAX_RESV_BW, UNRESV_BWS, IGP_COST, TE_COST});
    }

    public Double maxResvBandwidth() {
        String resvBw = this.get(MAX_RESV_BW, null);
        return resvBw != null ? Double.valueOf(resvBw) : 0.0;
    }

    public Double unResvBandwidth() {
        String unResvBw = this.get(UNRESV_BWS, null);
        return unResvBw != null ? Double.valueOf(unResvBw) : 0.0;
    }

    public int igpCost() {
        return this.get(IGP_COST, 0);
    }

    public int teCost() {
        return this.get(TE_COST, 0);
    }

    public TeLinkConfig maxResvBandwidth(Double maxResvBw) {
        return (TeLinkConfig)this.setOrClear(MAX_RESV_BW, maxResvBw);
    }

    public TeLinkConfig unResvBandwidth(Double unResvBw) {
        return (TeLinkConfig)this.setOrClear(UNRESV_BWS, unResvBw);
    }

    public TeLinkConfig igpCost(int igpCost) {
        return (TeLinkConfig)this.setOrClear(IGP_COST, igpCost);
    }

    public TeLinkConfig teCost(int teCost) {
        return (TeLinkConfig)this.setOrClear(TE_COST, teCost);
    }
}

