/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.api;

import java.net.URI;
import java.net.URISyntaxException;
import org.onosproject.pcep.tools.PcepTools;

public final class PcepDpid {
    private static final String SCHEME = "l3";
    private static final long UNKNOWN = 0L;
    private long nodeId;

    public PcepDpid() {
        this.nodeId = 0L;
    }

    public PcepDpid(long value) {
        this.nodeId = value;
    }

    public PcepDpid(String value) {
        this.nodeId = Long.parseLong(value, 16);
    }

    public static URI uri(PcepDpid dpid) {
        return PcepDpid.uri(dpid.nodeId);
    }

    public static long toLong(String value) {
        return PcepTools.ipToLong(value.replace(SCHEME, ""));
    }

    public static URI uri(long value) {
        try {
            return new URI(SCHEME, PcepTools.longToIp(value), null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public long value() {
        return this.nodeId;
    }
}

