/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.OvsdbMap;
import org.onosproject.ovsdb.rfc.notation.OvsdbSet;
import org.onosproject.ovsdb.rfc.notation.RefTableRow;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.schema.type.AtomicColumnType;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;
import org.onosproject.ovsdb.rfc.schema.type.BooleanBaseType;
import org.onosproject.ovsdb.rfc.schema.type.ColumnType;
import org.onosproject.ovsdb.rfc.schema.type.IntegerBaseType;
import org.onosproject.ovsdb.rfc.schema.type.KeyValuedColumnType;
import org.onosproject.ovsdb.rfc.schema.type.RealBaseType;
import org.onosproject.ovsdb.rfc.schema.type.StringBaseType;
import org.onosproject.ovsdb.rfc.schema.type.UuidBaseType;

public final class TransValueUtil {
    private TransValueUtil() {
    }

    public static Object getFormatData(Object value) {
        if (value instanceof Map) {
            return OvsdbMap.ovsdbMap((Map)value);
        }
        if (value instanceof Set) {
            return OvsdbSet.ovsdbSet((Set)value);
        }
        return value;
    }

    public static Object getValueFromJson(JsonNode json, ColumnType columnType) {
        if (columnType instanceof AtomicColumnType) {
            AtomicColumnType atoType = (AtomicColumnType)columnType;
            return TransValueUtil.getValueFromAtoType(json, atoType);
        }
        if (columnType instanceof KeyValuedColumnType) {
            KeyValuedColumnType kvType = (KeyValuedColumnType)columnType;
            return TransValueUtil.getValueFromKvType(json, kvType);
        }
        return null;
    }

    private static Object getValueFromAtoType(JsonNode json, AtomicColumnType atoType) {
        BaseType baseType = atoType.baseType();
        if (atoType.min() != atoType.max()) {
            HashSet set = Sets.newHashSet();
            if (json.isArray()) {
                if (json.size() == 2) {
                    if (json.get(0).isTextual() && "set".equals(json.get(0).asText())) {
                        for (JsonNode node : json.get(1)) {
                            set.add(TransValueUtil.transToValue(node, baseType));
                        }
                    } else {
                        set.add(TransValueUtil.transToValue(json, baseType));
                    }
                }
            } else {
                set.add(TransValueUtil.transToValue(json, baseType));
            }
            return OvsdbSet.ovsdbSet(set);
        }
        return TransValueUtil.transToValue(json, baseType);
    }

    private static Object getValueFromKvType(JsonNode json, KeyValuedColumnType kvType) {
        if (json.isArray() && json.size() == 2 && json.get(0).isTextual() && "map".equals(json.get(0).asText())) {
            HashMap map = Maps.newHashMap();
            for (JsonNode pairNode : json.get(1)) {
                if (!pairNode.isArray() || json.size() != 2) continue;
                Object key = TransValueUtil.transToValue(pairNode.get(0), kvType.keyType());
                Object value = TransValueUtil.transToValue(pairNode.get(1), kvType.valueType());
                map.put(key, value);
            }
            return OvsdbMap.ovsdbMap(map);
        }
        return null;
    }

    public static Object transToValue(JsonNode valueNode, BaseType baseType) {
        if (baseType instanceof BooleanBaseType) {
            return valueNode.asBoolean();
        }
        if (baseType instanceof IntegerBaseType) {
            return valueNode.asInt();
        }
        if (baseType instanceof RealBaseType) {
            return valueNode.asDouble();
        }
        if (baseType instanceof StringBaseType) {
            return valueNode.asText();
        }
        if (baseType instanceof UuidBaseType) {
            if (valueNode.isArray()) {
                if (valueNode.size() == 2 && valueNode.get(0).isTextual() && ("uuid".equals(valueNode.get(0).asText()) || "named-uuid".equals(valueNode.get(0).asText()))) {
                    return Uuid.uuid(valueNode.get(1).asText());
                }
            } else {
                return new RefTableRow(((UuidBaseType)baseType).getRefTable(), valueNode);
            }
        }
        return null;
    }
}

