/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.onosproject.ovsdb.rfc.message.MonitorRequest;
import org.onosproject.ovsdb.rfc.message.MonitorSelect;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.schema.TableSchema;

public final class ParamUtil {
    private ParamUtil() {
    }

    private static MonitorRequest getAllColumnsMonitorRequest(TableSchema tableSchema) {
        String tableName = tableSchema.name();
        Set<String> columns = tableSchema.getColumnNames();
        MonitorSelect select = new MonitorSelect(true, true, true, true);
        MonitorRequest monitorRequest = new MonitorRequest(tableName, columns, select);
        return monitorRequest;
    }

    public static List<Object> getMonitorParams(String monotorId, DatabaseSchema dbSchema) {
        Set<String> tables = dbSchema.getTableNames();
        HashMap mrMap = Maps.newHashMap();
        for (String tableName : tables) {
            TableSchema tableSchema = dbSchema.getTableSchema(tableName);
            MonitorRequest monitorRequest = ParamUtil.getAllColumnsMonitorRequest(tableSchema);
            mrMap.put(tableName, monitorRequest);
        }
        return Lists.newArrayList((Object[])new Object[]{dbSchema.name(), monotorId, mrMap});
    }

    public static List<Object> getTransactParams(DatabaseSchema dbSchema, List<Operation> operations) {
        ArrayList lists = Lists.newArrayList((Object[])new Object[]{dbSchema.name()});
        lists.addAll(operations);
        return lists;
    }
}

