/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.utils;

import java.util.List;
import org.onosproject.ovsdb.rfc.jsonrpc.JsonRpcRequest;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.utils.ObjectMapperUtil;
import org.onosproject.ovsdb.rfc.utils.ParamUtil;

public final class JsonRpcWriterUtil {
    private JsonRpcWriterUtil() {
    }

    private static String getRequestStr(String uuid, String methodName, List params) {
        JsonRpcRequest request = params != null ? new JsonRpcRequest(uuid, methodName, params) : new JsonRpcRequest(uuid, methodName);
        String str = ObjectMapperUtil.convertToString(request);
        return str;
    }

    public static String getSchemaStr(String uuid, List<String> dbnames) {
        String methodName = "get_schema";
        return JsonRpcWriterUtil.getRequestStr(uuid, methodName, dbnames);
    }

    public static String echoStr(String uuid) {
        String methodName = "echo";
        return JsonRpcWriterUtil.getRequestStr(uuid, methodName, null);
    }

    public static String monitorStr(String uuid, String monotorId, DatabaseSchema dbSchema) {
        String methodName = "monitor";
        return JsonRpcWriterUtil.getRequestStr(uuid, methodName, ParamUtil.getMonitorParams(monotorId, dbSchema));
    }

    public static String listDbsStr(String uuid) {
        String methodName = "list_dbs";
        return JsonRpcWriterUtil.getRequestStr(uuid, methodName, null);
    }

    public static String transactStr(String uuid, DatabaseSchema dbSchema, List<Operation> operations) {
        String methodName = "transact";
        return JsonRpcWriterUtil.getRequestStr(uuid, methodName, ParamUtil.getTransactParams(dbSchema, operations));
    }
}

