/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.utils;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.onosproject.ovsdb.rfc.exception.UnsupportedException;
import org.onosproject.ovsdb.rfc.jsonrpc.JsonReadContext;

public final class JsonRpcReaderUtil {
    private JsonRpcReaderUtil() {
    }

    public static void readToJsonNode(ByteBuf in, List<Object> out, JsonReadContext jrContext) throws JsonParseException, IOException {
        int i;
        int lastReadBytes = jrContext.getLastReadBytes();
        if (lastReadBytes == 0) {
            if (in.readableBytes() < 4) {
                return;
            }
            JsonRpcReaderUtil.checkEncoding(in);
        }
        Stack<Byte> bufStack = jrContext.getBufStack();
        for (i = lastReadBytes + in.readerIndex(); i < in.writerIndex(); ++i) {
            byte b = in.getByte(i);
            switch (b) {
                case 123: {
                    if (JsonRpcReaderUtil.isDoubleQuote(bufStack)) break;
                    bufStack.push(b);
                    jrContext.setStartMatch(true);
                    break;
                }
                case 125: {
                    if (JsonRpcReaderUtil.isDoubleQuote(bufStack)) break;
                    bufStack.pop();
                    break;
                }
                case 34: {
                    if (in.getByte(i - 1) == 92) break;
                    if (!bufStack.isEmpty() && bufStack.peek() != 34) {
                        bufStack.push(b);
                        break;
                    }
                    bufStack.pop();
                    break;
                }
            }
            if (!jrContext.isStartMatch() || !bufStack.isEmpty()) continue;
            ByteBuf buf = in.readSlice(i - in.readerIndex() + 1);
            JsonParser jf = new MappingJsonFactory().createParser((DataInput)new ByteBufInputStream(buf));
            JsonNode jsonNode = (JsonNode)jf.readValueAsTree();
            out.add(jsonNode);
            lastReadBytes = 0;
            jrContext.setLastReadBytes(lastReadBytes);
            break;
        }
        if (i >= in.writerIndex()) {
            lastReadBytes = in.readableBytes();
            jrContext.setLastReadBytes(lastReadBytes);
        }
    }

    private static void fliterCharaters(ByteBuf in) {
        byte ch;
        while (in.isReadable() && ((ch = in.getByte(in.readerIndex())) == 32 || ch == 10 || ch == 9 || ch == 13)) {
            in.readByte();
        }
    }

    private static boolean isDoubleQuote(Stack<Byte> bufStack) {
        return !bufStack.isEmpty() && bufStack.peek() == 34;
    }

    private static void checkEncoding(ByteBuf in) throws IOException {
        int inputStart = 0;
        int inputLength = 4;
        JsonRpcReaderUtil.fliterCharaters(in);
        byte[] buff = new byte[4];
        in.getBytes(in.readerIndex(), buff);
        ByteSourceJsonBootstrapper strapper = new ByteSourceJsonBootstrapper(new IOContext(new BufferRecycler(), null, false), buff, inputStart, inputLength);
        JsonEncoding jsonEncoding = strapper.detectEncoding();
        if (!JsonEncoding.UTF8.equals((Object)jsonEncoding)) {
            throw new UnsupportedException("Only UTF-8 encoding is supported.");
        }
    }
}

