/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onosproject.ovsdb.rfc.exception.AbnormalJsonNodeException;
import org.onosproject.ovsdb.rfc.exception.UnsupportedException;
import org.onosproject.ovsdb.rfc.jsonrpc.Callback;
import org.onosproject.ovsdb.rfc.jsonrpc.JsonRpcResponse;
import org.onosproject.ovsdb.rfc.message.OperationResult;
import org.onosproject.ovsdb.rfc.message.RowUpdate;
import org.onosproject.ovsdb.rfc.message.TableUpdate;
import org.onosproject.ovsdb.rfc.message.TableUpdates;
import org.onosproject.ovsdb.rfc.message.UpdateNotification;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.schema.ColumnSchema;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.schema.TableSchema;
import org.onosproject.ovsdb.rfc.schema.type.ColumnTypeFactory;
import org.onosproject.ovsdb.rfc.utils.ObjectMapperUtil;
import org.onosproject.ovsdb.rfc.utils.TransValueUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FromJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(FromJsonUtil.class);

    private FromJsonUtil() {
    }

    private static void validateJsonNode(JsonNode jsonNode, String nodeStr) {
        if (!jsonNode.isObject() || !jsonNode.has(nodeStr)) {
            String message = "Abnormal DatabaseSchema JsonNode, it should contain " + nodeStr + " node but was not found";
            throw new AbnormalJsonNodeException(message);
        }
    }

    public static DatabaseSchema jsonNodeToDbSchema(String dbName, JsonNode dbJson) {
        FromJsonUtil.validateJsonNode(dbJson, "tables");
        FromJsonUtil.validateJsonNode(dbJson, "version");
        String dbVersion = dbJson.get("version").asText();
        HashMap<String, TableSchema> tables = new HashMap<String, TableSchema>();
        Iterator tablesIter = dbJson.get("tables").fields();
        while (tablesIter.hasNext()) {
            Map.Entry table = (Map.Entry)tablesIter.next();
            tables.put((String)table.getKey(), FromJsonUtil.jsonNodeToTableSchema((String)table.getKey(), (JsonNode)table.getValue()));
        }
        return new DatabaseSchema(dbName, dbVersion, tables);
    }

    private static TableSchema jsonNodeToTableSchema(String tableName, JsonNode tableJson) {
        FromJsonUtil.validateJsonNode(tableJson, "columns");
        HashMap<String, ColumnSchema> columns = new HashMap<String, ColumnSchema>();
        Iterator columnsIter = tableJson.get("columns").fields();
        while (columnsIter.hasNext()) {
            Map.Entry column = (Map.Entry)columnsIter.next();
            columns.put((String)column.getKey(), FromJsonUtil.jsonNodeToColumnSchema((String)column.getKey(), (JsonNode)column.getValue()));
        }
        return new TableSchema(tableName, columns);
    }

    private static ColumnSchema jsonNodeToColumnSchema(String name, JsonNode columnJson) {
        FromJsonUtil.validateJsonNode(columnJson, "type");
        return new ColumnSchema(name, ColumnTypeFactory.getColumnTypeFromJson(columnJson.get("type")));
    }

    private static Object convertResultType(JsonNode resultJsonNode, String methodName, ObjectMapper objectMapper) {
        switch (methodName) {
            case "getSchema": 
            case "monitor": {
                return resultJsonNode;
            }
            case "echo": 
            case "listDbs": {
                return objectMapper.convertValue((Object)resultJsonNode, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{String.class}));
            }
            case "transact": {
                return objectMapper.convertValue((Object)resultJsonNode, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{JsonNode.class}));
            }
        }
        throw new UnsupportedException("does not support this rpc method" + methodName);
    }

    public static Object jsonResultParser(JsonNode jsonNode, String methodName) {
        ObjectMapper objectMapper = ObjectMapperUtil.getObjectMapper();
        JsonNode error = jsonNode.get("error");
        if (error != null && !error.isNull()) {
            log.error("jsonRpcResponse error : {}", (Object)error.toString());
        }
        JsonNode resultJsonNode = jsonNode.get("result");
        Object result = FromJsonUtil.convertResultType(resultJsonNode, methodName, objectMapper);
        return result;
    }

    public static void jsonCallbackRequestParser(JsonNode jsonNode, Callback callback) {
        String methodName;
        ObjectMapper objectMapper = ObjectMapperUtil.getObjectMapper();
        JsonNode params = jsonNode.get("params");
        Object param = null;
        switch (methodName = jsonNode.get("method").asText()) {
            case "update": {
                param = objectMapper.convertValue((Object)params, UpdateNotification.class);
                callback.update((UpdateNotification)param);
                break;
            }
            default: {
                throw new UnsupportedException("does not support this callback method: " + methodName);
            }
        }
    }

    public static String getEchoRequestStr(JsonNode jsonNode) {
        ObjectMapper objectMapper = ObjectMapperUtil.getObjectMapper();
        String str = null;
        if (jsonNode.get("method").asText().equals("echo")) {
            JsonRpcResponse response = new JsonRpcResponse(jsonNode.get("id").asText());
            try {
                str = objectMapper.writeValueAsString((Object)response);
            }
            catch (JsonProcessingException e) {
                log.error("JsonProcessingException while converting JsonNode into string: ", (Throwable)e);
            }
        }
        return str;
    }

    public static List<OperationResult> jsonNodeToOperationResult(List<JsonNode> input, List<Operation> operations) {
        ObjectMapper objectMapper = ObjectMapperUtil.getObjectMapper(false);
        ArrayList<OperationResult> operationResults = new ArrayList<OperationResult>();
        for (int i = 0; i < input.size(); ++i) {
            JsonNode jsonNode = input.get(i);
            Operation operation = operations.get(i);
            if (jsonNode == null || jsonNode.size() <= 0) continue;
            if (i >= operations.size() || !operation.getOp().equals("select")) {
                OperationResult or = (OperationResult)objectMapper.convertValue((Object)jsonNode, OperationResult.class);
                operationResults.add(or);
                continue;
            }
            ArrayList<Row> rows = FromJsonUtil.createRows(operation.getTableSchema(), jsonNode);
            OperationResult or = new OperationResult(rows);
            operationResults.add(or);
        }
        return operationResults;
    }

    private static ArrayList<Row> createRows(TableSchema tableSchema, JsonNode rowsNode) {
        FromJsonUtil.validateJsonNode(rowsNode, "rows");
        ArrayList rows = Lists.newArrayList();
        for (JsonNode rowNode : rowsNode.get("rows")) {
            rows.add(FromJsonUtil.createRow(tableSchema, null, rowNode));
        }
        return rows;
    }

    public static TableUpdates jsonNodeToTableUpdates(JsonNode updatesJson, DatabaseSchema dbSchema) {
        HashMap tableUpdateMap = Maps.newHashMap();
        Iterator tableUpdatesItr = updatesJson.fields();
        while (tableUpdatesItr.hasNext()) {
            Map.Entry entry = (Map.Entry)tableUpdatesItr.next();
            TableSchema tableSchema = dbSchema.getTableSchema((String)entry.getKey());
            TableUpdate tableUpdate = FromJsonUtil.jsonNodeToTableUpdate(tableSchema, (JsonNode)entry.getValue());
            tableUpdateMap.put(entry.getKey(), tableUpdate);
        }
        return TableUpdates.tableUpdates(tableUpdateMap);
    }

    public static TableUpdate jsonNodeToTableUpdate(TableSchema tableSchema, JsonNode updateJson) {
        HashMap rows = Maps.newHashMap();
        Iterator tableUpdateItr = updateJson.fields();
        while (tableUpdateItr.hasNext()) {
            Map.Entry oldNewRow = (Map.Entry)tableUpdateItr.next();
            String uuidStr = (String)oldNewRow.getKey();
            Uuid uuid = Uuid.uuid(uuidStr);
            JsonNode newR = ((JsonNode)oldNewRow.getValue()).get("new");
            JsonNode oldR = ((JsonNode)oldNewRow.getValue()).get("old");
            Row newRow = newR != null ? FromJsonUtil.createRow(tableSchema, uuid, newR) : null;
            Row oldRow = oldR != null ? FromJsonUtil.createRow(tableSchema, uuid, oldR) : null;
            RowUpdate rowUpdate = new RowUpdate(uuid, oldRow, newRow);
            rows.put(uuid, rowUpdate);
        }
        return TableUpdate.tableUpdate(rows);
    }

    private static Row createRow(TableSchema tableSchema, Uuid uuid, JsonNode rowNode) {
        if (tableSchema == null) {
            return null;
        }
        HashMap columns = Maps.newHashMap();
        Iterator rowIter = rowNode.fields();
        while (rowIter.hasNext()) {
            Map.Entry next = (Map.Entry)rowIter.next();
            ColumnSchema columnSchema = tableSchema.getColumnSchema((String)next.getKey());
            if (columnSchema == null) continue;
            String columnName = columnSchema.name();
            Object obj = TransValueUtil.getValueFromJson((JsonNode)next.getValue(), columnSchema.type());
            columns.put(columnName, new Column(columnName, obj));
        }
        return new Row(tableSchema.name(), uuid, columns);
    }
}

