/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.tableservice;

import com.google.common.base.Preconditions;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;

public class TableDescription {
    private final String name;
    private final String database = "Open_vSwitch";
    private final String fromVersion;
    private final String untilVersion;

    public TableDescription(OvsdbTable table) {
        Preconditions.checkNotNull((Object)((Object)table), (Object)"table cannot be null");
        this.name = table.tableName();
        this.fromVersion = "0.0.0";
        this.untilVersion = "0.0.0";
    }

    public TableDescription(OvsdbTable table, VersionNum fromVersion) {
        Preconditions.checkNotNull((Object)((Object)table), (Object)"table cannot be null");
        Preconditions.checkNotNull((Object)((Object)fromVersion), (Object)"the initial version cannot be null");
        this.name = table.tableName();
        this.fromVersion = fromVersion.versionNum();
        this.untilVersion = "0.0.0";
    }

    public TableDescription(OvsdbTable table, VersionNum fromVersion, VersionNum untilVersion) {
        Preconditions.checkNotNull((Object)((Object)table), (Object)"table cannot be null");
        Preconditions.checkNotNull((Object)((Object)fromVersion), (Object)"the initial version cannot be null");
        Preconditions.checkNotNull((Object)((Object)untilVersion), (Object)"the end of the version cannot be null");
        this.name = table.tableName();
        this.fromVersion = fromVersion.versionNum();
        this.untilVersion = untilVersion.versionNum();
    }

    public String name() {
        return this.name;
    }

    public String database() {
        return "Open_vSwitch";
    }

    public String fromVersion() {
        return this.fromVersion;
    }

    public String untilVersion() {
        return this.untilVersion;
    }
}

