/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.tableservice;

import com.google.common.base.Preconditions;
import org.onosproject.ovsdb.rfc.table.VersionNum;

public class ColumnDescription {
    private final String name;
    private final String method;
    private final String fromVersion;
    private final String untilVersion;

    public ColumnDescription(String name, String method) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)method, (Object)"method cannot be null");
        this.name = name;
        this.method = method;
        this.fromVersion = "0.0.0";
        this.untilVersion = "0.0.0";
    }

    public ColumnDescription(String name, String method, VersionNum fromVersion) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)method, (Object)"method cannot be null");
        Preconditions.checkNotNull((Object)((Object)fromVersion), (Object)"the initial version cannot be null");
        this.name = name;
        this.method = method;
        this.fromVersion = fromVersion.versionNum();
        this.untilVersion = "0.0.0";
    }

    public ColumnDescription(String name, String method, VersionNum fromVersion, VersionNum untilVersion) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)method, (Object)"method cannot be null");
        Preconditions.checkNotNull((Object)((Object)fromVersion), (Object)"the initial version cannot be null");
        Preconditions.checkNotNull((Object)((Object)untilVersion), (Object)"the end of the version cannot be null");
        this.name = name;
        this.method = method;
        this.fromVersion = fromVersion.versionNum();
        this.untilVersion = untilVersion.versionNum();
    }

    public String name() {
        return this.name;
    }

    public String method() {
        return this.method;
    }

    public String fromVersion() {
        return this.fromVersion;
    }

    public String untilVersion() {
        return this.untilVersion;
    }
}

