/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.tableservice;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.exception.ColumnSchemaNotFoundException;
import org.onosproject.ovsdb.rfc.exception.TableSchemaNotFoundException;
import org.onosproject.ovsdb.rfc.exception.VersionMismatchException;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.schema.ColumnSchema;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.schema.TableSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;
import org.onosproject.ovsdb.rfc.tableservice.OvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.TableDescription;
import org.onosproject.ovsdb.rfc.utils.VersionUtil;

public abstract class AbstractOvsdbTableService
implements OvsdbTableService {
    private final DatabaseSchema dbSchema;
    private final Row row;
    private final TableDescription tableDesc;

    public AbstractOvsdbTableService(DatabaseSchema dbSchema, Row row, OvsdbTable table, VersionNum formVersion) {
        TableDescription tableDesc;
        Preconditions.checkNotNull((Object)dbSchema, (Object)"database schema cannot be null");
        Preconditions.checkNotNull((Object)row, (Object)"row cannot be null");
        Preconditions.checkNotNull((Object)((Object)table), (Object)"table cannot be null");
        Preconditions.checkNotNull((Object)((Object)formVersion), (Object)"the initial version cannot be null");
        this.dbSchema = dbSchema;
        row.setTableName(table.tableName());
        this.row = row;
        this.tableDesc = tableDesc = new TableDescription(table, formVersion);
    }

    private boolean isValid() {
        if (this.dbSchema == null) {
            return false;
        }
        if (!this.dbSchema.name().equalsIgnoreCase(this.tableDesc.database())) {
            return false;
        }
        this.checkTableSchemaVersion();
        return true;
    }

    private void checkTableSchemaVersion() {
        String fromVersion = this.tableDesc.fromVersion();
        String untilVersion = this.tableDesc.untilVersion();
        String schemaVersion = this.dbSchema.version();
        this.checkVersion(schemaVersion, fromVersion, untilVersion);
    }

    private void checkColumnSchemaVersion(ColumnDescription columnDesc) {
        String fromVersion = columnDesc.fromVersion();
        String untilVersion = columnDesc.untilVersion();
        String schemaVersion = this.dbSchema.version();
        this.checkVersion(schemaVersion, fromVersion, untilVersion);
    }

    private void checkVersion(String schemaVersion, String fromVersion, String untilVersion) {
        VersionUtil.versionMatch(fromVersion);
        VersionUtil.versionMatch(untilVersion);
        if (!fromVersion.equals("0.0.0") && VersionUtil.versionCompare(schemaVersion, fromVersion) < 0) {
            String message = VersionMismatchException.createFromMessage(schemaVersion, fromVersion);
            throw new VersionMismatchException(message);
        }
        if (!untilVersion.equals("0.0.0") && VersionUtil.versionCompare(untilVersion, schemaVersion) < 0) {
            String message = VersionMismatchException.createToMessage(schemaVersion, untilVersion);
            throw new VersionMismatchException(message);
        }
    }

    private TableSchema getTableSchema() {
        String tableName = this.tableDesc.name();
        return this.dbSchema.getTableSchema(tableName);
    }

    private ColumnSchema getColumnSchema(String columnName) {
        TableSchema tableSchema = this.getTableSchema();
        if (tableSchema == null) {
            String message = TableSchemaNotFoundException.createMessage(this.tableDesc.name(), this.dbSchema.name());
            throw new TableSchemaNotFoundException(message);
        }
        ColumnSchema columnSchema = tableSchema.getColumnSchema(columnName);
        if (columnSchema == null) {
            String message = ColumnSchemaNotFoundException.createMessage(columnName, tableSchema.name());
            throw new ColumnSchemaNotFoundException(message);
        }
        return columnSchema;
    }

    @Override
    public Column getColumnHandler(ColumnDescription columnDesc) {
        if (!this.isValid()) {
            return null;
        }
        String columnName = columnDesc.name();
        this.checkColumnSchemaVersion(columnDesc);
        ColumnSchema columnSchema = this.getColumnSchema(columnName);
        if (this.row == null) {
            return null;
        }
        return this.row.getColumn(columnSchema.name());
    }

    @Override
    public Object getDataHandler(ColumnDescription columnDesc) {
        if (!this.isValid()) {
            return null;
        }
        String columnName = columnDesc.name();
        this.checkColumnSchemaVersion(columnDesc);
        ColumnSchema columnSchema = this.getColumnSchema(columnName);
        if (this.row == null || this.row.getColumn(columnSchema.name()) == null) {
            return null;
        }
        return this.row.getColumn(columnSchema.name()).data();
    }

    @Override
    public void setDataHandler(ColumnDescription columnDesc, Object obj) {
        if (!this.isValid()) {
            return;
        }
        String columnName = columnDesc.name();
        this.checkColumnSchemaVersion(columnDesc);
        ColumnSchema columnSchema = this.getColumnSchema(columnName);
        Column column = new Column(columnSchema.name(), obj);
        this.row.addColumn(columnName, column);
    }

    @Override
    public Uuid getTableUuid() {
        if (!this.isValid()) {
            return null;
        }
        ColumnDescription columnDesc = new ColumnDescription("_uuid", "getTableUuid");
        return (Uuid)this.getDataHandler(columnDesc);
    }

    @Override
    public Column getTableUuidColumn() {
        if (!this.isValid()) {
            return null;
        }
        ColumnDescription columnDesc = new ColumnDescription("_uuid", "getTableUuidColumn");
        return this.getColumnHandler(columnDesc);
    }

    @Override
    public Uuid getTableVersion() {
        if (!this.isValid()) {
            return null;
        }
        ColumnDescription columnDesc = new ColumnDescription("_version", "getTableVersion");
        return (Uuid)this.getDataHandler(columnDesc);
    }

    @Override
    public Column getTableVersionColumn() {
        if (!this.isValid()) {
            return null;
        }
        ColumnDescription columnDesc = new ColumnDescription("_version", "getTableVersionColumn");
        return this.getColumnHandler(columnDesc);
    }

    public DatabaseSchema dbSchema() {
        return this.dbSchema;
    }

    public Row getRow() {
        if (!this.isValid()) {
            return null;
        }
        return this.row;
    }

    public TableDescription tableDesc() {
        return this.tableDesc;
    }

    public int hashCode() {
        return this.row.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractOvsdbTableService) {
            AbstractOvsdbTableService other = (AbstractOvsdbTableService)obj;
            return Objects.equals(this.row, other.row);
        }
        return false;
    }

    public String toString() {
        TableSchema schema = this.getTableSchema();
        String tableName = schema.name();
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)tableName).add("row", (Object)this.row).toString();
    }
}

