/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.Bridge;
import org.onosproject.ovsdb.rfc.table.Controller;
import org.onosproject.ovsdb.rfc.table.FlowSampleCollectorSet;
import org.onosproject.ovsdb.rfc.table.FlowTable;
import org.onosproject.ovsdb.rfc.table.Interface;
import org.onosproject.ovsdb.rfc.table.Ipfix;
import org.onosproject.ovsdb.rfc.table.Manager;
import org.onosproject.ovsdb.rfc.table.Mirror;
import org.onosproject.ovsdb.rfc.table.Netflow;
import org.onosproject.ovsdb.rfc.table.OpenVSwitch;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.Port;
import org.onosproject.ovsdb.rfc.table.Qos;
import org.onosproject.ovsdb.rfc.table.Queue;
import org.onosproject.ovsdb.rfc.table.Sflow;
import org.onosproject.ovsdb.rfc.table.Ssl;

public final class TableGenerator {
    private TableGenerator() {
    }

    public static Object createTable(DatabaseSchema dbSchema, OvsdbTable tableName) {
        Row row = new Row();
        return TableGenerator.generateTable(dbSchema, row, tableName);
    }

    public static Object getTable(DatabaseSchema dbSchema, Row row, OvsdbTable tableName) {
        return TableGenerator.generateTable(dbSchema, row, tableName);
    }

    private static Object generateTable(DatabaseSchema dbSchema, Row row, OvsdbTable tableName) {
        switch (tableName) {
            case INTERFACE: {
                return new Interface(dbSchema, row);
            }
            case BRIDGE: {
                return new Bridge(dbSchema, row);
            }
            case CONTROLLER: {
                return new Controller(dbSchema, row);
            }
            case OPENVSWITCH: {
                return new OpenVSwitch(dbSchema, row);
            }
            case PORT: {
                return new Port(dbSchema, row);
            }
            case FLWTABLE: {
                return new FlowTable(dbSchema, row);
            }
            case QOS: {
                return new Qos(dbSchema, row);
            }
            case QUEUE: {
                return new Queue(dbSchema, row);
            }
            case MIRROR: {
                return new Mirror(dbSchema, row);
            }
            case MANAGER: {
                return new Manager(dbSchema, row);
            }
            case NETFLOW: {
                return new Netflow(dbSchema, row);
            }
            case SSL: {
                return new Ssl(dbSchema, row);
            }
            case SFLOW: {
                return new Sflow(dbSchema, row);
            }
            case IPFIX: {
                return new Ipfix(dbSchema, row);
            }
            case FLOWSAMPLECOLLECTORSET: {
                return new FlowSampleCollectorSet(dbSchema, row);
            }
        }
        return null;
    }
}

