/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Ssl
extends AbstractOvsdbTableService {
    public Ssl(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.SSL, VersionNum.VERSION100);
    }

    public Column getCaCertColumn() {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.CACERT.columnName(), "getCaCertColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setCaCert(String caCert) {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.CACERT.columnName(), "setCaCert", VersionNum.VERSION100);
        super.setDataHandler(columndesc, caCert);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getBootstrapCaCertColumn() {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.BOOTSTRAPCACERT.columnName(), "getBootstrapCaCertColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setBootstrapCaCert(Boolean bootstrapCaCert) {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.BOOTSTRAPCACERT.columnName(), "setBootstrapCaCert", VersionNum.VERSION100);
        super.setDataHandler(columndesc, bootstrapCaCert);
    }

    public Column getCertificateColumn() {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.CERTIFICATE.columnName(), "getCertificateColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setCertificate(String certificate) {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.CERTIFICATE.columnName(), "setCertificate", VersionNum.VERSION100);
        super.setDataHandler(columndesc, certificate);
    }

    public Column getPrivateKeyColumn() {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.PRIVATEKEY.columnName(), "getPrivateKeyColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setPrivateKey(String privatekey) {
        ColumnDescription columndesc = new ColumnDescription(SslColumn.PRIVATEKEY.columnName(), "setPrivateKey", VersionNum.VERSION100);
        super.setDataHandler(columndesc, privatekey);
    }

    public static enum SslColumn {
        CACERT("ca_cert"),
        EXTERNALIDS("external_ids"),
        BOOTSTRAPCACERT("bootstrap_ca_cert"),
        CERTIFICATE("certificate"),
        PRIVATEKEY("private_key");

        private final String columnName;

        private SslColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

