/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Sflow
extends AbstractOvsdbTableService {
    public Sflow(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.SFLOW, VersionNum.VERSION100);
    }

    public Column getTargetsColumn() {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.TARGETS.columnName(), "getTargetsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setTargets(Set<String> targets) {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.TARGETS.columnName(), "setTargets", VersionNum.VERSION100);
        super.setDataHandler(columndesc, targets);
    }

    public Column getAgentColumn() {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.AGENT.columnName(), "getAgentColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setAgent(Set<String> agent) {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.AGENT.columnName(), "setAgent", VersionNum.VERSION100);
        super.setDataHandler(columndesc, agent);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getHeaderColumn() {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.HAEDER.columnName(), "getHeaderColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setHeader(Set<Long> header) {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.HAEDER.columnName(), "setHeader", VersionNum.VERSION100);
        super.setDataHandler(columndesc, header);
    }

    public Column getPollingColumn() {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.POLLING.columnName(), "getPollingColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setPolling(Set<Long> polling) {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.POLLING.columnName(), "setPolling", VersionNum.VERSION100);
        super.setDataHandler(columndesc, polling);
    }

    public Column getSamplingColumn() {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.SAMPLING.columnName(), "getSamplingColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setSampling(Set<Long> sampling) {
        ColumnDescription columndesc = new ColumnDescription(SflowColumn.SAMPLING.columnName(), "setSampling", VersionNum.VERSION100);
        super.setDataHandler(columndesc, sampling);
    }

    public static enum SflowColumn {
        TARGETS("targets"),
        AGENT("agent"),
        EXTERNALIDS("external_ids"),
        HAEDER("header"),
        POLLING("polling"),
        SAMPLING("sampling");

        private final String columnName;

        private SflowColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

