/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Queue
extends AbstractOvsdbTableService {
    public Queue(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.QUEUE, VersionNum.VERSION100);
    }

    public Column getDscpColumn() {
        ColumnDescription columndesc = new ColumnDescription(QueueColumn.DSCP.columnName(), "getDscpColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setDscp(Set<Long> dscp) {
        ColumnDescription columndesc = new ColumnDescription(QueueColumn.DSCP.columnName(), "setDscp", VersionNum.VERSION100);
        super.setDataHandler(columndesc, dscp);
    }

    public Column getOtherConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(QueueColumn.OTHERCONFIG.columnName(), "getOtherConfigColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setOtherConfig(Map<String, String> otherConfig) {
        ColumnDescription columndesc = new ColumnDescription(QueueColumn.OTHERCONFIG.columnName(), "setOtherConfig", VersionNum.VERSION100);
        super.setDataHandler(columndesc, otherConfig);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(QueueColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(QueueColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public static enum QueueColumn {
        DSCP("dscp"),
        OTHERCONFIG("other_config"),
        EXTERNALIDS("external_ids");

        private final String columnName;

        private QueueColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

