/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Port
extends AbstractOvsdbTableService {
    public Port(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.PORT, VersionNum.VERSION100);
    }

    public Column getNameColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.NAME.columnName(), "getNameColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setName(String name) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.NAME.columnName(), "setName", VersionNum.VERSION100);
        super.setDataHandler(columndesc, name);
    }

    public String getName() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.NAME.columnName(), "getName", VersionNum.VERSION100);
        return (String)super.getDataHandler(columndesc);
    }

    public Column getInterfacesColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.INTERFACES.columnName(), "getInterfacesColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setInterfaces(Set<Uuid> interfaces) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.INTERFACES.columnName(), "setInterfaces", VersionNum.VERSION100);
        super.setDataHandler(columndesc, interfaces);
    }

    public Column getTrunksColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.TRUNKS.columnName(), "getTrunksColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setTrunks(Set<Long> trunks) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.TRUNKS.columnName(), "setTrunks", VersionNum.VERSION100);
        super.setDataHandler(columndesc, trunks);
    }

    public Column getTagColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.TAG.columnName(), "getTagColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setTag(Set<Long> tag) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.TAG.columnName(), "setTag", VersionNum.VERSION100);
        super.setDataHandler(columndesc, tag);
    }

    public Column getVlanModeColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.VLANMODE.columnName(), "getVlanModeColumn", VersionNum.VERSION610);
        return super.getColumnHandler(columndesc);
    }

    public void setVlanMode(Set<String> vlanMode) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.VLANMODE.columnName(), "setVlanMode", VersionNum.VERSION610);
        super.setDataHandler(columndesc, vlanMode);
    }

    public Column getQosColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.QOS.columnName(), "getQosColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    @Deprecated
    public void setQos(Set<Uuid> qos) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.QOS.columnName(), "setQos", VersionNum.VERSION100);
        super.setDataHandler(columndesc, qos);
    }

    public void setQos(Uuid qos) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.QOS.columnName(), "setQos", VersionNum.VERSION100);
        super.setDataHandler(columndesc, qos);
    }

    public Column getMacColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.MAC.columnName(), "getMacColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setMac(Set<String> mac) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.MAC.columnName(), "setMac", VersionNum.VERSION100);
        super.setDataHandler(columndesc, mac);
    }

    public Column getBondTypeColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDTYPE.columnName(), "getBondTypeColumn", VersionNum.VERSION102, VersionNum.VERSION103);
        return super.getColumnHandler(columndesc);
    }

    public void setBondType(Set<String> bondtype) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDTYPE.columnName(), "setBondType", VersionNum.VERSION102, VersionNum.VERSION103);
        super.setDataHandler(columndesc, bondtype);
    }

    public Column getBondModeColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDMODE.columnName(), "getBondModeColumn", VersionNum.VERSION104);
        return super.getColumnHandler(columndesc);
    }

    public void setBondMode(Set<String> bondmode) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDMODE.columnName(), "setBondMode", VersionNum.VERSION104);
        super.setDataHandler(columndesc, bondmode);
    }

    public Column getLacpColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.LACP.columnName(), "getLacpColumn", VersionNum.VERSION130);
        return super.getColumnHandler(columndesc);
    }

    public void setLacp(Set<String> lacp) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.LACP.columnName(), "setLacp", VersionNum.VERSION130);
        super.setDataHandler(columndesc, lacp);
    }

    public Column getBondUpDelayColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDUPDELAY.columnName(), "getBondUpDelayColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setBondUpDelay(Set<Long> bondUpDelay) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDUPDELAY.columnName(), "setBondUpDelay", VersionNum.VERSION100);
        super.setDataHandler(columndesc, bondUpDelay);
    }

    public Column getBondDownDelayColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDDOWNDELAY.columnName(), "getBondDownDelayColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setBondDownDelay(Set<Long> bondDownDelay) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDDOWNDELAY.columnName(), "setBondDownDelay", VersionNum.VERSION100);
        super.setDataHandler(columndesc, bondDownDelay);
    }

    public Column getBondFakeInterfaceColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDFAKEIFACE.columnName(), "getBondFakeInterfaceColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setBondFakeInterface(Set<Boolean> bondFakeInterface) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.BONDFAKEIFACE.columnName(), "setBondFakeInterface", VersionNum.VERSION100);
        super.setDataHandler(columndesc, bondFakeInterface);
    }

    public Column getFakeBridgeColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.FAKEBRIDGE.columnName(), "getFakeBridgeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setFakeBridge(Set<Boolean> fakeBridge) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.FAKEBRIDGE.columnName(), "setFakeBridge", VersionNum.VERSION100);
        super.setDataHandler(columndesc, fakeBridge);
    }

    public Column getStatusColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.STATUS.columnName(), "getStatusColumn", VersionNum.VERSION620);
        return super.getColumnHandler(columndesc);
    }

    public void setStatus(Map<String, String> status) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.STATUS.columnName(), "setStatus", VersionNum.VERSION620);
        super.setDataHandler(columndesc, status);
    }

    public Column getStatisticsColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.STATISTICS.columnName(), "getStatisticsColumn", VersionNum.VERSION630);
        return super.getColumnHandler(columndesc);
    }

    public void setStatistics(Map<String, Long> statistics) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.STATISTICS.columnName(), "setStatistics", VersionNum.VERSION630);
        super.setDataHandler(columndesc, statistics);
    }

    public Column getOtherConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.OTHERCONFIG.columnName(), "getOtherConfigColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setOtherConfig(Map<String, String> otherConfig) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.OTHERCONFIG.columnName(), "setOtherConfig", VersionNum.VERSION100);
        super.setDataHandler(columndesc, otherConfig);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(PortColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public static enum PortColumn {
        NAME("name"),
        INTERFACES("interfaces"),
        TRUNKS("trunks"),
        TAG("tag"),
        VLANMODE("vlan_mode"),
        QOS("qos"),
        MAC("mac"),
        BONDTYPE("bond_type"),
        BONDMODE("bond_mode"),
        LACP("lacp"),
        BONDUPDELAY("bond_updelay"),
        BONDDOWNDELAY("bond_downdelay"),
        BONDFAKEIFACE("bond_fake_iface"),
        FAKEBRIDGE("fake_bridge"),
        STATUS("status"),
        STATISTICS("statistics"),
        OTHERCONFIG("other_config"),
        EXTERNALIDS("external_ids");

        private final String columnName;

        private PortColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

