/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class OpenVSwitch
extends AbstractOvsdbTableService {
    public OpenVSwitch(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.OPENVSWITCH, VersionNum.VERSION100);
    }

    public Column getBridgesColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.BRIDGES.columnName(), "getBridgesColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setBridges(Set<Uuid> bridges) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.BRIDGES.columnName(), "setBridges", VersionNum.VERSION100);
        super.setDataHandler(columndesc, bridges);
    }

    public Column getManagersColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.MANAGERS.columnName(), "getManagersColumn", VersionNum.VERSION100, VersionNum.VERSION200);
        return (Column)super.getDataHandler(columndesc);
    }

    public void setManagers(Set<Uuid> managers) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.MANAGERS.columnName(), "setManagers", VersionNum.VERSION100, VersionNum.VERSION200);
        super.setDataHandler(columndesc, managers);
    }

    public Column getManagerOptionsColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.MANAGEROPTIONS.columnName(), "getManagerOptionsColumn", VersionNum.VERSION100);
        return (Column)super.getDataHandler(columndesc);
    }

    public void setManagerOptions(Set<Uuid> managerOptions) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.MANAGEROPTIONS.columnName(), "setManagerOptions", VersionNum.VERSION100);
        super.setDataHandler(columndesc, managerOptions);
    }

    public Column getSslColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.SSL.columnName(), "getSslColumn", VersionNum.VERSION100);
        return (Column)super.getDataHandler(columndesc);
    }

    public void setSsl(Set<Uuid> ssl) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.SSL.columnName(), "setSsl", VersionNum.VERSION100);
        super.setDataHandler(columndesc, ssl);
    }

    public Column getOtherConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.OTHERCONFIG.columnName(), "getOtherConfigColumn", VersionNum.VERSION510);
        return super.getColumnHandler(columndesc);
    }

    public void setOtherConfig(Map<String, String> otherConfig) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.OTHERCONFIG.columnName(), "setOtherConfig", VersionNum.VERSION510);
        super.setDataHandler(columndesc, otherConfig);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getNextConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.NEXTCFG.columnName(), "getNextConfigColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setNextConfig(Long nextConfig) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.NEXTCFG.columnName(), "setNextConfig", VersionNum.VERSION100);
        super.setDataHandler(columndesc, nextConfig);
    }

    public Column getCurrentConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.CURCFG.columnName(), "getCurrentConfigColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setCurrentConfig(Long currentConfig) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.CURCFG.columnName(), "setCurrentConfig", VersionNum.VERSION100);
        super.setDataHandler(columndesc, currentConfig);
    }

    public Column getCapabilitiesColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.CAPABILITIES.columnName(), "getCapabilitiesColumn", VersionNum.VERSION100, VersionNum.VERSION670);
        return super.getColumnHandler(columndesc);
    }

    public void setCapabilities(Map<String, Uuid> capabilities) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.CAPABILITIES.columnName(), "setCapabilities", VersionNum.VERSION100, VersionNum.VERSION670);
        super.setDataHandler(columndesc, capabilities);
    }

    public Column getStatisticsColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.STATISTICS.columnName(), "getStatisticsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setStatistics(Map<String, Long> statistics) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.STATISTICS.columnName(), "setStatistics", VersionNum.VERSION100);
        super.setDataHandler(columndesc, statistics);
    }

    public Column getOvsVersionColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.OVSVERSION.columnName(), "getOvsVersionColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setOvsVersion(Set<String> ovsVersion) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.OVSVERSION.columnName(), "setOvsVersion", VersionNum.VERSION100);
        super.setDataHandler(columndesc, ovsVersion);
    }

    public Column getDbVersionColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.DBVERSION.columnName(), "getDbVersionColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setDbVersion(Set<String> dbVersion) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.DBVERSION.columnName(), "setDbVersion", VersionNum.VERSION100);
        super.setDataHandler(columndesc, dbVersion);
    }

    public Column getSystemTypeColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.SYSTEMTYPE.columnName(), "getSystemTypeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setSystemType(Set<String> systemType) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.SYSTEMTYPE.columnName(), "setSystemType", VersionNum.VERSION100);
        super.setDataHandler(columndesc, systemType);
    }

    public Column getSystemVersionColumn() {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.SYSTEMVERSION.columnName(), "getSystemVersionColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setSystemVersion(Set<String> systemVersion) {
        ColumnDescription columndesc = new ColumnDescription(OpenVSwitchColumn.SYSTEMVERSION.columnName(), "setSystemVersion", VersionNum.VERSION100);
        super.setDataHandler(columndesc, systemVersion);
    }

    public static enum OpenVSwitchColumn {
        BRIDGES("bridges"),
        MANAGERS("managers"),
        MANAGEROPTIONS("manager_options"),
        SSL("ssl"),
        OTHERCONFIG("other_config"),
        EXTERNALIDS("external_ids"),
        NEXTCFG("next_cfg"),
        CURCFG("cur_cfg"),
        CAPABILITIES("capabilities"),
        STATISTICS("statistics"),
        OVSVERSION("ovs_version"),
        DBVERSION("db_version"),
        SYSTEMTYPE("system_type"),
        SYSTEMVERSION("system_version");

        private final String columnName;

        private OpenVSwitchColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

