/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Netflow
extends AbstractOvsdbTableService {
    public Netflow(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.NETFLOW, VersionNum.VERSION100);
    }

    public Column getTargetsColumn() {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.TARGETS.columnName(), "getTargetsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setTargets(Set<String> targets) {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.TARGETS.columnName(), "setTargets", VersionNum.VERSION100);
        super.setDataHandler(columndesc, targets);
    }

    public Column getActiveTimeoutColumn() {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ACTIVETIMEOUT.columnName(), "getActiveTimeoutColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setActiveTimeout(Long activeTimeout) {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ACTIVETIMEOUT.columnName(), "setActiveTimeout", VersionNum.VERSION100);
        super.setDataHandler(columndesc, activeTimeout);
    }

    public Column getEngineTypeColumn() {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ENGINETYPE.columnName(), "getEngineTypeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setEngineType(Set<Long> engineType) {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ENGINETYPE.columnName(), "setEngineType", VersionNum.VERSION100);
        super.setDataHandler(columndesc, engineType);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getAddIdToInterfaceColumn() {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ADDIDTOINTERFACE.columnName(), "getAddIdToInterfaceColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setAddIdToInterface(Boolean addIdToInterface) {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ADDIDTOINTERFACE.columnName(), "setAddIdToInterface", VersionNum.VERSION100);
        super.setDataHandler(columndesc, addIdToInterface);
    }

    public Column getEngineIdColumn() {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ENGINETYPE.columnName(), "getEngineIdColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setEngineId(Set<Long> engineId) {
        ColumnDescription columndesc = new ColumnDescription(NetflowColumn.ENGINETYPE.columnName(), "setEngineId", VersionNum.VERSION100);
        super.setDataHandler(columndesc, engineId);
    }

    public static enum NetflowColumn {
        TARGETS("targets"),
        ACTIVETIMEOUT("active_timeout"),
        ENGINETYPE("engine_type"),
        EXTERNALIDS("external_ids"),
        ADDIDTOINTERFACE("add_id_to_interface"),
        ENGINEID("engine_id");

        private final String columnName;

        private NetflowColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

