/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Manager
extends AbstractOvsdbTableService {
    public Manager(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.MANAGER, VersionNum.VERSION100);
    }

    public Column getTargetColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.TARGET.columnName(), "getTargetColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setTarget(Set<String> target) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.TARGET.columnName(), "setTarget", VersionNum.VERSION100);
        super.setDataHandler(columndesc, target);
    }

    public Column getIsConnectedColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.ISCONNECTED.columnName(), "getIsConnectedColumn", VersionNum.VERSION110);
        return super.getColumnHandler(columndesc);
    }

    public void setIsConnected(Boolean isConnected) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.ISCONNECTED.columnName(), "setIsConnected", VersionNum.VERSION110);
        super.setDataHandler(columndesc, isConnected);
    }

    public Column getOtherConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.OTHERCONFIG.columnName(), "getOtherConfigColumn", VersionNum.VERSION680);
        return super.getColumnHandler(columndesc);
    }

    public void setOtherConfig(Map<String, String> otherConfig) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.OTHERCONFIG.columnName(), "setOtherConfig", VersionNum.VERSION680);
        super.setDataHandler(columndesc, otherConfig);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getMaxBackoffColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.MAXBACKOFF.columnName(), "getMaxBackoffColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setMaxBackoff(Set<Long> maxBackoff) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.MAXBACKOFF.columnName(), "setMaxBackoff", VersionNum.VERSION100);
        super.setDataHandler(columndesc, maxBackoff);
    }

    public Column getStatusColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.STATUS.columnName(), "getStatusColumn", VersionNum.VERSION110);
        return super.getColumnHandler(columndesc);
    }

    public void setStatus(Map<String, String> status) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.STATUS.columnName(), "setStatus", VersionNum.VERSION110);
        super.setDataHandler(columndesc, status);
    }

    public Column getInactivityProbeColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.INACTIVITYPROBE.columnName(), "getInactivityProbeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setInactivityProbe(Set<Long> inactivityProbe) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.INACTIVITYPROBE.columnName(), "setInactivityProbe", VersionNum.VERSION100);
        super.setDataHandler(columndesc, inactivityProbe);
    }

    public Column getConnectionModeColumn() {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.CONNECTIONMODE.columnName(), "getConnectionModeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setConnectionMode(Set<String> connectionMode) {
        ColumnDescription columndesc = new ColumnDescription(ManagerColumn.CONNECTIONMODE.columnName(), "setConnectionMode", VersionNum.VERSION100);
        super.setDataHandler(columndesc, connectionMode);
    }

    public static enum ManagerColumn {
        TARGET("target"),
        ISCONNECTED("is_connected"),
        CONNECTIONMODE("connection_mode"),
        EXTERNALIDS("external_ids"),
        STATUS("status"),
        INACTIVITYPROBE("inactivity_probe"),
        OTHERCONFIG("other_config"),
        MAXBACKOFF("max_backoff");

        private final String columnName;

        private ManagerColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

