/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Ipfix
extends AbstractOvsdbTableService {
    public Ipfix(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.IPFIX, VersionNum.VERSION710);
    }

    public Column getTargetsColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.TARGETS.columnName(), "getTargetsColumn", VersionNum.VERSION710);
        return super.getColumnHandler(columndesc);
    }

    public void setTargets(Set<String> targets) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.TARGETS.columnName(), "setTargets", VersionNum.VERSION710);
        super.setDataHandler(columndesc, targets);
    }

    public Column getSamplingColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.SAMPLING.columnName(), "getSamplingColumn", VersionNum.VERSION710);
        return super.getColumnHandler(columndesc);
    }

    public void setSampling(Set<Long> sampling) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.SAMPLING.columnName(), "setSampling", VersionNum.VERSION710);
        super.setDataHandler(columndesc, sampling);
    }

    public Column getObsDomainIdColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.OBSDOMAINID.columnName(), "getObsDomainIdColumn", VersionNum.VERSION710);
        return super.getColumnHandler(columndesc);
    }

    public void setObsDomainId(Set<Long> obsdomainid) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.OBSDOMAINID.columnName(), "setObsDomainId", VersionNum.VERSION710);
        super.setDataHandler(columndesc, obsdomainid);
    }

    public Column getObsPointIdColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.OBSPOINTID.columnName(), "getObsPointIdColumn", VersionNum.VERSION710);
        return super.getColumnHandler(columndesc);
    }

    public void setObsPointId(Set<Long> obsPointId) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.OBSPOINTID.columnName(), "setObsPointId", VersionNum.VERSION710);
        super.setDataHandler(columndesc, obsPointId);
    }

    public Column getCacheActiveTimeoutColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.CACHEACTIVETIMEOUT.columnName(), "getCacheActiveTimeoutColumn", VersionNum.VERSION730);
        return super.getColumnHandler(columndesc);
    }

    public void setCacheActiveTimeout(Set<Long> cacheActiveTimeout) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.CACHEACTIVETIMEOUT.columnName(), "setCacheActiveTimeout", VersionNum.VERSION730);
        super.setDataHandler(columndesc, cacheActiveTimeout);
    }

    public Column getCacheMaxFlowsColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.CACHEMAXFLOWS.columnName(), "getCacheMaxFlowsColumn", VersionNum.VERSION730);
        return super.getColumnHandler(columndesc);
    }

    public void setCacheMaxFlows(Set<Long> cacheMaxFlows) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.CACHEMAXFLOWS.columnName(), "setCacheMaxFlows", VersionNum.VERSION730);
        super.setDataHandler(columndesc, cacheMaxFlows);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION710);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(IpfixColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION710);
        super.setDataHandler(columndesc, externalIds);
    }

    public static enum IpfixColumn {
        TARGETS("targets"),
        SAMPLING("sampling"),
        OBSDOMAINID("obs_domain_id"),
        OBSPOINTID("obs_point_id"),
        CACHEACTIVETIMEOUT("cache_active_timeout"),
        EXTERNALIDS("external_ids"),
        CACHEMAXFLOWS("cache_max_flows");

        private final String columnName;

        private IpfixColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

