/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Controller
extends AbstractOvsdbTableService {
    public Controller(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.CONTROLLER, VersionNum.VERSION100);
    }

    public Column getTargetColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.TARGET.columnName(), "getTargetColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setTarget(String target) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.TARGET.columnName(), "setTarget", VersionNum.VERSION100);
        super.setDataHandler(columndesc, target);
    }

    public Column getBurstLimitColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.BURSTLIMIT.columnName(), "getBurstLimitColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setBurstLimit(Long burstLimit) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.BURSTLIMIT.columnName(), "setBurstLimit", VersionNum.VERSION100);
        super.setDataHandler(columndesc, burstLimit);
    }

    public Column getRateLimitColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.RATELIMIT.columnName(), "getRateLimitColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setRateLimit(Long rateLimit) {
        ColumnDescription columndesc = new ColumnDescription("controller_rate_limit", "setRateLimit", VersionNum.VERSION100);
        super.setDataHandler(columndesc, rateLimit);
    }

    public Column getConnectionModeColumn() {
        ColumnDescription columndesc = new ColumnDescription("connection_mode", "getConnectionModeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setConnectionMode(Set<String> connectionMode) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.RATELIMIT.columnName(), "setConnectionMode", VersionNum.VERSION100);
        super.setDataHandler(columndesc, connectionMode);
    }

    public Column getEnableAsyncMessagesColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.ENABLEASYNCMESSAGES.columnName(), "getEnableAsyncMessagesColumn", VersionNum.VERSION670);
        return super.getColumnHandler(columndesc);
    }

    public void setEnableAsyncMessages(Set<Boolean> enableAsyncMessages) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.ENABLEASYNCMESSAGES.columnName(), "setEnableAsyncMessages", VersionNum.VERSION670);
        super.setDataHandler(columndesc, enableAsyncMessages);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getLocalNetmaskColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.LOCALNETMASK.columnName(), "getLocalNetmaskColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setLocalNetmask(Set<String> localNetmask) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.LOCALNETMASK.columnName(), "setLocalNetmask", VersionNum.VERSION100);
        super.setDataHandler(columndesc, localNetmask);
    }

    public Column getLocalGatewayColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.LOCALGATEWAY.columnName(), "getLocalGatewayColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setLocalGateway(Set<String> localGateway) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.LOCALGATEWAY.columnName(), "setLocalGateway", VersionNum.VERSION100);
        super.setDataHandler(columndesc, localGateway);
    }

    public Column getStatusColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.STATUS.columnName(), "getStatusColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setStatus(Map<String, String> status) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.STATUS.columnName(), "setStatus", VersionNum.VERSION100);
        super.setDataHandler(columndesc, status);
    }

    public Column getRoleColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.ROLE.columnName(), "getRoleColumn", VersionNum.VERSION110);
        return super.getColumnHandler(columndesc);
    }

    public void setRole(Set<String> role) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.ROLE.columnName(), "setRole", VersionNum.VERSION110);
        super.setDataHandler(columndesc, role);
    }

    public Column getInactivityProbeColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.INACTIVITYPROBE.columnName(), "getInactivityProbeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setInactivityProbe(Set<Long> inactivityProbe) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.INACTIVITYPROBE.columnName(), "setInactivityProbe", VersionNum.VERSION100);
        super.setDataHandler(columndesc, inactivityProbe);
    }

    public Column getIsConnectedColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.ISCONNECTED.columnName(), "getIsConnectedColumn", VersionNum.VERSION110);
        return super.getColumnHandler(columndesc);
    }

    public void setIsConnected(Boolean isConnected) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.ISCONNECTED.columnName(), "setIsConnected", VersionNum.VERSION110);
        super.setDataHandler(columndesc, isConnected);
    }

    public Column getOtherConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.OTHERCONFIG.columnName(), "getOtherConfigColumn", VersionNum.VERSION680);
        return super.getColumnHandler(columndesc);
    }

    public void setOtherConfig(Map<String, String> otherConfig) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.OTHERCONFIG.columnName(), "setOtherConfig", VersionNum.VERSION680);
        super.setDataHandler(columndesc, otherConfig);
    }

    public Column getMaxBackoffColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.MAXBACKOFF.columnName(), "getMaxBackoffColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setMaxBackoff(Long maxBackoff) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.MAXBACKOFF.columnName(), "setMaxBackoff", VersionNum.VERSION100);
        super.setDataHandler(columndesc, maxBackoff);
    }

    public Column getLocalIpColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.LOCALIP.columnName(), "getLocalIpColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setLocalIp(Set<String> localIp) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.LOCALIP.columnName(), "setLocalIp", VersionNum.VERSION100);
        super.setDataHandler(columndesc, localIp);
    }

    public Column getDiscoverUpdateResolvConfColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.DISCOVERUPDATERESOLVCONF.columnName(), "getDiscoverUpdateResolvConfColumn", VersionNum.VERSION100, VersionNum.VERSION300);
        return super.getColumnHandler(columndesc);
    }

    public void setDiscoverUpdateResolvConf(Set<String> discoverUpdateResolvConf) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.DISCOVERUPDATERESOLVCONF.columnName(), "setDiscoverUpdateResolvConf", VersionNum.VERSION100, VersionNum.VERSION300);
        super.setDataHandler(columndesc, discoverUpdateResolvConf);
    }

    public Column getDiscoverAcceptRegexColumn() {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.DISCOVERACCEPTREGEX.columnName(), "getDiscoverAcceptRegexColumn", VersionNum.VERSION100, VersionNum.VERSION300);
        return super.getColumnHandler(columndesc);
    }

    public void setDiscoverAcceptRegex(Set<String> discoverAcceptRegex) {
        ColumnDescription columndesc = new ColumnDescription(ControllerColumn.DISCOVERACCEPTREGEX.columnName(), "setDiscoverAcceptRegex", VersionNum.VERSION100, VersionNum.VERSION300);
        super.setDataHandler(columndesc, discoverAcceptRegex);
    }

    public static enum ControllerColumn {
        TARGET("target"),
        BURSTLIMIT("controller_burst_limit"),
        RATELIMIT("controller_rate_limit"),
        CONNECTIONMODE("connection_mode"),
        ENABLEASYNCMESSAGES("enable_async_messages"),
        EXTERNALIDS("external_ids"),
        LOCALNETMASK("local_netmask"),
        LOCALGATEWAY("local_gateway"),
        STATUS("status"),
        ROLE("role"),
        INACTIVITYPROBE("inactivity_probe"),
        ISCONNECTED("is_connected"),
        OTHERCONFIG("other_config"),
        MAXBACKOFF("max_backoff"),
        LOCALIP("local_ip"),
        DISCOVERUPDATERESOLVCONF("discover_update_resolv_conf"),
        DISCOVERACCEPTREGEX("discover_accept_regex");

        private final String columnName;

        private ControllerColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

