/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.table;

import java.util.Map;
import java.util.Set;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.OvsdbSet;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;
import org.onosproject.ovsdb.rfc.table.VersionNum;
import org.onosproject.ovsdb.rfc.tableservice.AbstractOvsdbTableService;
import org.onosproject.ovsdb.rfc.tableservice.ColumnDescription;

public class Bridge
extends AbstractOvsdbTableService {
    public Bridge(DatabaseSchema dbSchema, Row row) {
        super(dbSchema, row, OvsdbTable.BRIDGE, VersionNum.VERSION100);
    }

    public Column getNameColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.NAME.columnName(), "getNameColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setName(String name) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.NAME.columnName(), "setName", VersionNum.VERSION100);
        super.setDataHandler(columndesc, name);
    }

    public String getName() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.NAME.columnName(), "getName", VersionNum.VERSION100);
        return (String)super.getDataHandler(columndesc);
    }

    public Column getDatapathTypeColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.DATAPATHTYPE.columnName(), "getDatapathTypeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setDatapathType(String datapathType) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.DATAPATHTYPE.columnName(), "setDatapathType", VersionNum.VERSION100);
        super.setDataHandler(columndesc, datapathType);
    }

    public Column getDatapathIdColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.DATAPATHID.columnName(), "getDatapathIdColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setDatapathId(Set<String> datapathId) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.DATAPATHID.columnName(), "setDatapathId", VersionNum.VERSION100);
        super.setDataHandler(columndesc, datapathId);
    }

    public Column getStpEnableColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.STPENABLE.columnName(), "getStpEnableColumn", VersionNum.VERSION620);
        return super.getColumnHandler(columndesc);
    }

    public void setStpEnable(Boolean stpenable) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.STPENABLE.columnName(), "setStpEnable", VersionNum.VERSION620);
        super.setDataHandler(columndesc, stpenable);
    }

    public Column getPortsColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.PORTS.columnName(), "getPortsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setPorts(Set<Uuid> ports) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.PORTS.columnName(), "setPorts", VersionNum.VERSION100);
        super.setDataHandler(columndesc, ports);
    }

    public Column getMirrorsColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.MIRRORS.columnName(), "getMirrorsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setMirrors(Set<Uuid> mirrors) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.MIRRORS.columnName(), "setMirrors", VersionNum.VERSION100);
        super.setDataHandler(columndesc, mirrors);
    }

    public Column getNetflowColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.NETFLOW.columnName(), "getNetflowColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setNetflow(Set<Uuid> netflow) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.NETFLOW.columnName(), "setNetflow", VersionNum.VERSION100);
        super.setDataHandler(columndesc, netflow);
    }

    public Column getSflowColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.SFLOW.columnName(), "getSflowColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setSflow(Set<Uuid> sflow) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.SFLOW.columnName(), "setSflow", VersionNum.VERSION100);
        super.setDataHandler(columndesc, sflow);
    }

    public Column getIpfixColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.IPFIX.columnName(), "getIpfixColumn", VersionNum.VERSION710);
        return super.getColumnHandler(columndesc);
    }

    public void setIpfix(Set<Uuid> ipfix) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.IPFIX.columnName(), "setIpfix", VersionNum.VERSION710);
        super.setDataHandler(columndesc, ipfix);
    }

    public Column getControllerColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.CONTROLLER.columnName(), "getControllerColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setController(OvsdbSet controller) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.CONTROLLER.columnName(), "setController", VersionNum.VERSION100);
        super.setDataHandler(columndesc, controller);
    }

    public Column getProtocolsColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.PROTOCOLS.columnName(), "getProtocolsColumn", VersionNum.VERSION6111);
        return super.getColumnHandler(columndesc);
    }

    public void setProtocols(Set<String> protocols) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.PROTOCOLS.columnName(), "setProtocols", VersionNum.VERSION6111);
        super.setDataHandler(columndesc, protocols);
    }

    public Column getFailModeColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.FAILMODE.columnName(), "getFailModeColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setFailMode(Set<String> failMode) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.FAILMODE.columnName(), "setFailMode", VersionNum.VERSION100);
        super.setDataHandler(columndesc, failMode);
    }

    public Column getStatusColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.STATUS.columnName(), "getStatusColumn", VersionNum.VERSION620);
        return super.getColumnHandler(columndesc);
    }

    public void setStatus(Map<String, String> status) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.STATUS.columnName(), "setStatus", VersionNum.VERSION620);
        super.setDataHandler(columndesc, status);
    }

    public Column getOtherConfigColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.OTHERCONFIG.columnName(), "getOtherConfigColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setOtherConfig(Map<String, String> otherConfig) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.OTHERCONFIG.columnName(), "setOtherConfig", VersionNum.VERSION100);
        super.setDataHandler(columndesc, otherConfig);
    }

    public Column getExternalIdsColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.EXTERNALIDS.columnName(), "getExternalIdsColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setExternalIds(Map<String, String> externalIds) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.EXTERNALIDS.columnName(), "setExternalIds", VersionNum.VERSION100);
        super.setDataHandler(columndesc, externalIds);
    }

    public Column getFloodVlansColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.FLOODVLANS.columnName(), "getFloodVlansColumn", VersionNum.VERSION100);
        return super.getColumnHandler(columndesc);
    }

    public void setFloodVlans(Set<Long> vlans) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.FLOODVLANS.columnName(), "setFloodVlans", VersionNum.VERSION100);
        super.setDataHandler(columndesc, vlans);
    }

    public Column getFlowTablesColumn() {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.FLOWTABLES.columnName(), "getFlowTablesColumn", VersionNum.VERSION650);
        return super.getColumnHandler(columndesc);
    }

    public void setFlowTables(Map<Long, Uuid> flowTables) {
        ColumnDescription columndesc = new ColumnDescription(BridgeColumn.FLOWTABLES.columnName(), "setFlowTables", VersionNum.VERSION650);
        super.setDataHandler(columndesc, flowTables);
    }

    public static enum BridgeColumn {
        NAME("name"),
        DATAPATHTYPE("datapath_type"),
        DATAPATHID("datapath_id"),
        STPENABLE("stpenable"),
        PORTS("ports"),
        MIRRORS("mirrors"),
        NETFLOW("netflow"),
        SFLOW("sflow"),
        IPFIX("ipfix"),
        CONTROLLER("controller"),
        PROTOCOLS("protocols"),
        FAILMODE("fail_mode"),
        STATUS("status"),
        OTHERCONFIG("other_config"),
        EXTERNALIDS("external_ids"),
        FLOODVLANS("flood_vlans"),
        FLOWTABLES("flow_tables");

        private final String columnName;

        private BridgeColumn(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }
    }
}

